/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.zstd.BitStream;
import io.airlift.compress.zstd.FseTableReader;
import io.airlift.compress.zstd.UnsafeUtil;
import io.airlift.compress.zstd.Util;
import sun.misc.Unsafe;

class FiniteStateEntropy {
    private static final int MAX_TABLE_LOG = 12;
    private final Table table;
    private final FseTableReader reader = new FseTableReader();

    public FiniteStateEntropy(int maxLog) {
        this.table = new Table(maxLog);
    }

    public int decompress(Object inputBase, long inputAddress, long inputLimit, byte[] weights) {
        long output;
        long outputAddress;
        block3: {
            byte numberOfBits;
            long input = inputAddress;
            input += (long)this.reader.readFseTable(this.table, inputBase, input, inputLimit, 255, 12);
            byte[] outputBase = weights;
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET;
            long outputLimit = outputAddress + (long)weights.length;
            BitStream.Initializer initializer = new BitStream.Initializer(inputBase, input, inputLimit);
            initializer.initialize();
            int bitsConsumed = initializer.getBitsConsumed();
            long currentAddress = initializer.getCurrentAddress();
            long bits = initializer.getBits();
            int state1 = (int)BitStream.peekBits(bitsConsumed, bits, this.table.log2Size);
            BitStream.Loader loader = new BitStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += this.table.log2Size);
            loader.load();
            bits = loader.getBits();
            bitsConsumed = loader.getBitsConsumed();
            currentAddress = loader.getCurrentAddress();
            int state2 = (int)BitStream.peekBits(bitsConsumed, bits, this.table.log2Size);
            loader = new BitStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += this.table.log2Size);
            loader.load();
            bits = loader.getBits();
            bitsConsumed = loader.getBitsConsumed();
            currentAddress = loader.getCurrentAddress();
            byte[] symbols = this.table.symbol;
            byte[] numbersOfBits = this.table.numberOfBits;
            int[] newStates = this.table.newState;
            for (output = outputAddress; output <= outputLimit - 4L; output += 4L) {
                UnsafeUtil.UNSAFE.putByte(outputBase, output, symbols[state1]);
                numberOfBits = numbersOfBits[state1];
                state1 = (int)((long)newStates[state1] + BitStream.peekBits(bitsConsumed, bits, numberOfBits));
                bitsConsumed += numberOfBits;
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 1L, symbols[state2]);
                numberOfBits = numbersOfBits[state2];
                state2 = (int)((long)newStates[state2] + BitStream.peekBits(bitsConsumed, bits, numberOfBits));
                bitsConsumed += numberOfBits;
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 2L, symbols[state1]);
                numberOfBits = numbersOfBits[state1];
                state1 = (int)((long)newStates[state1] + BitStream.peekBits(bitsConsumed, bits, numberOfBits));
                bitsConsumed += numberOfBits;
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 3L, symbols[state2]);
                numberOfBits = numbersOfBits[state2];
                state2 = (int)((long)newStates[state2] + BitStream.peekBits(bitsConsumed, bits, numberOfBits));
                loader = new BitStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += numberOfBits);
                boolean done = loader.load();
                bitsConsumed = loader.getBitsConsumed();
                bits = loader.getBits();
                currentAddress = loader.getCurrentAddress();
                if (!done) continue;
                break;
            }
            do {
                Util.verify(output <= outputLimit - 2L, input, "Output buffer is too small");
                UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state1]);
                numberOfBits = numbersOfBits[state1];
                state1 = (int)((long)newStates[state1] + BitStream.peekBits(bitsConsumed, bits, numberOfBits));
                loader = new BitStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += numberOfBits);
                loader.load();
                bitsConsumed = loader.getBitsConsumed();
                bits = loader.getBits();
                currentAddress = loader.getCurrentAddress();
                if (loader.isOverflow()) {
                    UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state2]);
                    break block3;
                }
                Util.verify(output <= outputLimit - 2L, input, "Output buffer is too small");
                UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state2]);
                byte numberOfBits1 = numbersOfBits[state2];
                state2 = (int)((long)newStates[state2] + BitStream.peekBits(bitsConsumed, bits, numberOfBits1));
                loader = new BitStream.Loader(inputBase, input, currentAddress, bits, bitsConsumed += numberOfBits1);
                loader.load();
                bitsConsumed = loader.getBitsConsumed();
                bits = loader.getBits();
                currentAddress = loader.getCurrentAddress();
            } while (!loader.isOverflow());
            UnsafeUtil.UNSAFE.putByte(outputBase, output++, symbols[state1]);
        }
        return (int)(output - outputAddress);
    }

    public static final class Table {
        int log2Size;
        final int[] newState;
        final byte[] symbol;
        final byte[] numberOfBits;

        public Table(int log2Size) {
            int size = 1 << log2Size;
            this.newState = new int[size];
            this.symbol = new byte[size];
            this.numberOfBits = new byte[size];
        }

        public Table(int log2Size, int[] newState, byte[] symbol, byte[] numberOfBits) {
            int size = 1 << log2Size;
            if (newState.length != size || symbol.length != size || numberOfBits.length != size) {
                throw new IllegalArgumentException("Expected arrays to match provided size");
            }
            this.log2Size = log2Size;
            this.newState = newState;
            this.symbol = symbol;
            this.numberOfBits = numberOfBits;
        }
    }
}

