/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ReflectionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.ThriftObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hive.com.google.common.primitives.UnsignedBytes;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftUnionObjectInspector
extends ReflectionStructObjectInspector
implements UnionObjectInspector {
    private static final String FIELD_METADATA_MAP = "metaDataMap";
    private List<ObjectInspector> ois;
    private List<StandardStructObjectInspector.MyField> fields;

    @Override
    public boolean shouldIgnoreField(String name) {
        return name.startsWith("__isset");
    }

    @Override
    public List<ObjectInspector> getObjectInspectors() {
        return this.ois;
    }

    @Override
    public byte getTag(Object o) {
        if (o == null) {
            return -1;
        }
        Object setField = ((TUnion)o).getSetField();
        return UnsignedBytes.checkedCast(setField.getThriftFieldId() - 1);
    }

    @Override
    public Object getField(Object o) {
        if (o == null) {
            return null;
        }
        return ((TUnion)o).getFieldValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init(Type type, Class<?> objectClass, ObjectInspectorFactory.ObjectInspectorOptions options) {
        Field fieldMetaData;
        this.type = type;
        this.verifyObjectClassType(objectClass);
        this.objectClass = objectClass;
        try {
            fieldMetaData = objectClass.getDeclaredField(FIELD_METADATA_MAP);
            assert (Map.class.isAssignableFrom(fieldMetaData.getType()));
            fieldMetaData.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to find field metadata for thrift union field ", e);
        }
        try {
            Map fieldMap = (Map)fieldMetaData.get(null);
            ThriftUnionObjectInspector thriftUnionObjectInspector = this;
            synchronized (thriftUnionObjectInspector) {
                this.fields = new ArrayList<StandardStructObjectInspector.MyField>(fieldMap.size());
                this.ois = new ArrayList<ObjectInspector>();
                for (Map.Entry metadata : fieldMap.entrySet()) {
                    short fieldId = ((TFieldIdEnum)metadata.getKey()).getThriftFieldId();
                    String fieldName = ((FieldMetaData)metadata.getValue()).fieldName;
                    Type fieldType = ThriftObjectInspectorUtils.getFieldType(objectClass, fieldName);
                    ObjectInspector reflectionObjectInspector = ObjectInspectorFactory.getReflectionObjectInspector(fieldType, options, false);
                    this.fields.add(new StandardStructObjectInspector.MyField(fieldId, fieldName, reflectionObjectInspector));
                    this.ois.add(reflectionObjectInspector);
                }
                this.inited = true;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to find field metadata for thrift union field ", e);
        }
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }

    @Override
    public synchronized List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardUnionTypeName(this);
    }
}

