/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hive.com.google.common.collect.ImmutableList;

public class HiveRelMdCollation
implements MetadataHandler<BuiltInMetadata.Collation> {
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLLATIONS.method, new HiveRelMdCollation()), RelMdCollation.SOURCE));

    private HiveRelMdCollation() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Collation> getDef() {
        return BuiltInMetadata.Collation.DEF;
    }

    public ImmutableList<RelCollation> collations(HiveAggregate aggregate, RelMetadataQuery mq) {
        ImmutableList.Builder collationListBuilder = new ImmutableList.Builder();
        for (int pos : aggregate.getGroupSet().asList()) {
            RelFieldCollation fieldCollation = new RelFieldCollation(pos);
            collationListBuilder.add(fieldCollation);
        }
        return ImmutableList.of(RelCollationTraitDef.INSTANCE.canonize(new HiveRelCollation((ImmutableList<RelFieldCollation>)collationListBuilder.build())));
    }

    public ImmutableList<RelCollation> collations(HiveJoin join, RelMetadataQuery mq) {
        return join.getCollation();
    }
}

