/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hive.com.google.common.collect.Sets;

public class HiveAggregate
extends Aggregate
implements HiveRelNode {
    private LinkedHashSet<Integer> aggregateColumnsOrder;

    public HiveAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, indicator, groupSet, groupSets, aggCalls);
    }

    @Override
    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new HiveAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getDistinctRowCount(this, this.groupSet, this.getCluster().getRexBuilder().makeLiteral(true));
    }

    public boolean isBucketedInput() {
        return RelMetadataQuery.instance().distribution(this.getInput()).getKeys().containsAll(this.groupSet.asList());
    }

    @Override
    protected RelDataType deriveRowType() {
        return HiveAggregate.deriveRowType(this.getCluster().getTypeFactory(), this.getInput().getRowType(), this.indicator, this.groupSet, this.groupSets, this.aggCalls);
    }

    public static RelDataType deriveRowType(RelDataTypeFactory typeFactory, RelDataType inputRowType, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        List<Integer> groupList = groupSet.asList();
        assert (groupList.size() == groupSet.cardinality());
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        List<RelDataTypeField> fieldList = inputRowType.getFieldList();
        HashSet<String> containedNames = Sets.newHashSet();
        Iterator<Object> iterator = groupList.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            containedNames.add(fieldList.get(n).getName());
            builder.add(fieldList.get(n));
        }
        if (indicator) {
            iterator = groupList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                RelDataType booleanType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
                String name = "i$" + fieldList.get(n).getName();
                int i = 0;
                while (containedNames.contains(name)) {
                    name = name + "_" + i++;
                }
                containedNames.add(name);
                builder.add(name, booleanType);
            }
        }
        for (Ord ord : Ord.zip(aggCalls)) {
            String name = ((AggregateCall)ord.e).name != null ? ((AggregateCall)ord.e).name : "$f" + (groupList.size() + ord.i);
            int i = 0;
            while (containedNames.contains(name)) {
                name = name + "_" + i++;
            }
            containedNames.add(name);
            builder.add(name, ((AggregateCall)ord.e).type);
        }
        return builder.build();
    }

    public void setAggregateColumnsOrder(LinkedHashSet<Integer> aggregateColumnsOrder) {
        this.aggregateColumnsOrder = aggregateColumnsOrder;
    }

    public LinkedHashSet<Integer> getAggregateColumnsOrder() {
        return this.aggregateColumnsOrder;
    }
}

