/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.cost;

import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;

public class HiveCost
implements RelOptCost {
    public static final HiveCost INFINITY = new HiveCost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public String toString() {
            return "{inf}";
        }
    };
    public static final HiveCost HUGE = new HiveCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        public String toString() {
            return "{huge}";
        }
    };
    public static final HiveCost ZERO = new HiveCost(0.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{0}";
        }
    };
    public static final HiveCost TINY = new HiveCost(1.0, 1.0, 0.0){

        @Override
        public String toString() {
            return "{tiny}";
        }
    };
    public static final RelOptCostFactory FACTORY = new Factory();
    final double cpu;
    final double io;
    final double rowCount;

    HiveCost(double rowCount, double cpu, double io) {
        assert (rowCount >= 0.0);
        assert (cpu >= 0.0);
        assert (io >= 0.0);
        this.rowCount = rowCount;
        this.cpu = cpu;
        this.io = io;
    }

    @Override
    public double getCpu() {
        return this.cpu;
    }

    @Override
    public boolean isInfinite() {
        return this == INFINITY || this.rowCount == Double.POSITIVE_INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY;
    }

    @Override
    public double getIo() {
        return this.io;
    }

    @Override
    public boolean isLe(RelOptCost other) {
        return this.cpu + this.io < other.getCpu() + other.getIo() || this.cpu + this.io == other.getCpu() + other.getIo() && this.rowCount <= other.getRows();
    }

    @Override
    public boolean isLt(RelOptCost other) {
        return this.isLe(other) && !this.equals(other);
    }

    @Override
    public double getRows() {
        return this.rowCount;
    }

    @Override
    public boolean equals(RelOptCost other) {
        return this == other || this.cpu + this.io == other.getCpu() + other.getIo() && this.rowCount == other.getRows();
    }

    @Override
    public boolean isEqWithEpsilon(RelOptCost other) {
        return this == other || Math.abs(this.io - other.getIo()) < 1.0E-5 && Math.abs(this.cpu - other.getCpu()) < 1.0E-5 && Math.abs(this.rowCount - other.getRows()) < 1.0E-5;
    }

    @Override
    public RelOptCost minus(RelOptCost other) {
        if (this == INFINITY) {
            return this;
        }
        return new HiveCost(this.rowCount - other.getRows(), this.cpu - other.getCpu(), this.io - other.getIo());
    }

    @Override
    public RelOptCost multiplyBy(double factor) {
        if (this == INFINITY) {
            return this;
        }
        return new HiveCost(this.rowCount * factor, this.cpu * factor, this.io * factor);
    }

    @Override
    public double divideBy(RelOptCost cost) {
        double d = 1.0;
        double n = 0.0;
        if (this.rowCount != 0.0 && !Double.isInfinite(this.rowCount) && cost.getRows() != 0.0 && !Double.isInfinite(cost.getRows())) {
            d *= this.rowCount / cost.getRows();
            n += 1.0;
        }
        if (this.cpu != 0.0 && !Double.isInfinite(this.cpu) && cost.getCpu() != 0.0 && !Double.isInfinite(cost.getCpu())) {
            d *= this.cpu / cost.getCpu();
            n += 1.0;
        }
        if (this.io != 0.0 && !Double.isInfinite(this.io) && cost.getIo() != 0.0 && !Double.isInfinite(cost.getIo())) {
            d *= this.io / cost.getIo();
            n += 1.0;
        }
        if (n == 0.0) {
            return 1.0;
        }
        return Math.pow(d, 1.0 / n);
    }

    @Override
    public RelOptCost plus(RelOptCost other) {
        if (this == INFINITY || other.isInfinite()) {
            return INFINITY;
        }
        return new HiveCost(this.rowCount + other.getRows(), this.cpu + other.getCpu(), this.io + other.getIo());
    }

    @Override
    public String toString() {
        return "{" + this.rowCount + " rows, " + this.cpu + " cpu, " + this.io + " io}";
    }

    private static class Factory
    implements RelOptCostFactory {
        private Factory() {
        }

        @Override
        public RelOptCost makeCost(double rowCount, double cpu, double io) {
            return new HiveCost(rowCount, cpu, io);
        }

        @Override
        public RelOptCost makeHugeCost() {
            return HUGE;
        }

        @Override
        public HiveCost makeInfiniteCost() {
            return INFINITY;
        }

        @Override
        public HiveCost makeTinyCost() {
            return TINY;
        }

        @Override
        public HiveCost makeZeroCost() {
            return ZERO;
        }
    }
}

