/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Util;
import org.apache.hive.com.google.common.base.Predicates;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableMap;
import org.apache.hive.com.google.common.collect.Iterables;

public class SqlTypeExplicitPrecedenceList
implements RelDataTypePrecedenceList {
    private static final List<SqlTypeName> NUMERIC_TYPES = ImmutableNullableList.of(SqlTypeName.TINYINT, null, SqlTypeName.SMALLINT, null, SqlTypeName.INTEGER, null, SqlTypeName.BIGINT, null, new SqlTypeName[]{SqlTypeName.DECIMAL, null, SqlTypeName.REAL, null, SqlTypeName.FLOAT, SqlTypeName.DOUBLE});
    private static final List<SqlTypeName> COMPACT_NUMERIC_TYPES = ImmutableList.copyOf(Iterables.filter(NUMERIC_TYPES, Predicates.notNull()));
    private static final Map<SqlTypeName, SqlTypeExplicitPrecedenceList> TYPE_NAME_TO_PRECEDENCE_LIST = ImmutableMap.builder().put(SqlTypeName.BOOLEAN, SqlTypeExplicitPrecedenceList.list(SqlTypeName.BOOLEAN)).put(SqlTypeName.TINYINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.TINYINT)).put(SqlTypeName.SMALLINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.SMALLINT)).put(SqlTypeName.INTEGER, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.INTEGER)).put(SqlTypeName.BIGINT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.BIGINT)).put(SqlTypeName.DECIMAL, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.DECIMAL)).put(SqlTypeName.REAL, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.REAL)).put(SqlTypeName.FLOAT, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.FLOAT)).put(SqlTypeName.DOUBLE, SqlTypeExplicitPrecedenceList.numeric(SqlTypeName.DOUBLE)).put(SqlTypeName.CHAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.CHAR, SqlTypeName.VARCHAR)).put(SqlTypeName.VARCHAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARCHAR)).put(SqlTypeName.BINARY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.BINARY, SqlTypeName.VARBINARY)).put(SqlTypeName.VARBINARY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.VARBINARY)).put(SqlTypeName.DATE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DATE)).put(SqlTypeName.TIME, SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIME)).put(SqlTypeName.TIMESTAMP, SqlTypeExplicitPrecedenceList.list(SqlTypeName.TIMESTAMP)).put(SqlTypeName.INTERVAL_YEAR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.YEAR_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_YEAR_MONTH, SqlTypeExplicitPrecedenceList.list(SqlTypeName.YEAR_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_MONTH, SqlTypeExplicitPrecedenceList.list(SqlTypeName.YEAR_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_HOUR, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_MINUTE, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).put(SqlTypeName.INTERVAL_SECOND, SqlTypeExplicitPrecedenceList.list(SqlTypeName.DAY_INTERVAL_TYPES)).build();
    private final List<SqlTypeName> typeNames;

    public SqlTypeExplicitPrecedenceList(Iterable<SqlTypeName> typeNames) {
        this.typeNames = ImmutableNullableList.copyOf(typeNames);
    }

    private static SqlTypeExplicitPrecedenceList list(SqlTypeName ... typeNames) {
        return SqlTypeExplicitPrecedenceList.list(Arrays.asList(typeNames));
    }

    private static SqlTypeExplicitPrecedenceList list(Iterable<SqlTypeName> typeNames) {
        return new SqlTypeExplicitPrecedenceList(typeNames);
    }

    private static SqlTypeExplicitPrecedenceList numeric(SqlTypeName typeName) {
        int i = SqlTypeExplicitPrecedenceList.getListPosition(typeName, COMPACT_NUMERIC_TYPES);
        return new SqlTypeExplicitPrecedenceList(Util.skip(COMPACT_NUMERIC_TYPES, i));
    }

    @Override
    public boolean containsType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        return typeName != null && this.typeNames.contains((Object)typeName);
    }

    @Override
    public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
        assert (this.containsType(type1));
        assert (this.containsType(type2));
        int p1 = SqlTypeExplicitPrecedenceList.getListPosition(type1.getSqlTypeName(), this.typeNames);
        int p2 = SqlTypeExplicitPrecedenceList.getListPosition(type2.getSqlTypeName(), this.typeNames);
        return p2 - p1;
    }

    private static int getListPosition(SqlTypeName type, List<SqlTypeName> list) {
        int i = list.indexOf((Object)type);
        assert (i != -1);
        for (int j = i - 1; j >= 0; --j) {
            if (list.get(j) != null) continue;
            return j;
        }
        return i;
    }

    static RelDataTypePrecedenceList getListForType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        return TYPE_NAME_TO_PRECEDENCE_LIST.get((Object)typeName);
    }
}

