/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.collect.ImmutableMap;

public class SqlJdbcFunctionCall
extends SqlFunction {
    private static final String NUMERIC_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE");
    private static final String STRING_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("ASCII", "CHAR", "CONCAT", "DIFFERENCE", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTRING", "UCASE");
    private static final String TIME_DATE_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("CURDATE", "CURTIME", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "TIMESTAMPADD", "TIMESTAMPDIFF", "WEEK", "YEAR");
    private static final String SYSTEM_FUNCTIONS = SqlJdbcFunctionCall.constructFuncList("DATABASE", "IFNULL", "USER");
    private final String jdbcName;
    private final MakeCall lookupMakeCallObj;
    private SqlCall lookupCall;
    private SqlNode[] thisOperands;

    public SqlJdbcFunctionCall(String name) {
        super("{fn " + name + "}", SqlKind.JDBC_FN, null, null, OperandTypes.VARIADIC, SqlFunctionCategory.SYSTEM);
        this.jdbcName = name;
        this.lookupMakeCallObj = JdbcToInternalLookupTable.INSTANCE.lookup(name);
        this.lookupCall = null;
    }

    private static String constructFuncList(String ... functionNames) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (String funcName : functionNames) {
            if (JdbcToInternalLookupTable.INSTANCE.lookup(funcName) == null) continue;
            if (n++ > 0) {
                sb.append(",");
            }
            sb.append(funcName);
        }
        return sb.toString();
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        this.thisOperands = operands;
        return super.createCall(functionQualifier, pos, operands);
    }

    public SqlCall getLookupCall() {
        if (null == this.lookupCall) {
            this.lookupCall = this.lookupMakeCallObj.createCall(SqlParserPos.ZERO, this.thisOperands);
        }
        return this.lookupCall;
    }

    @Override
    public String getAllowedSignatures(String name) {
        return this.lookupMakeCallObj.getOperator().getAllowedSignatures(name);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            validator.setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        SqlCallBinding callBinding = (SqlCallBinding)opBinding;
        if (null == this.lookupMakeCallObj) {
            throw callBinding.newValidationError(Static.RESOURCE.functionUndefined(this.getName()));
        }
        String message = this.lookupMakeCallObj.isValidArgCount(callBinding);
        if (message != null) {
            throw callBinding.newValidationError(Static.RESOURCE.wrongNumberOfParam(this.getName(), this.thisOperands.length, message));
        }
        SqlCall newCall = this.getLookupCall();
        SqlCallBinding newBinding = new SqlCallBinding(callBinding.getValidator(), callBinding.getScope(), newCall);
        SqlOperator operator = this.lookupMakeCallObj.getOperator();
        if (!operator.checkOperandTypes(newBinding, false)) {
            throw callBinding.newValidationSignatureError();
        }
        return operator.validateOperands(callBinding.getValidator(), callBinding.getScope(), newCall);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.print("{fn ");
        writer.print(this.jdbcName);
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
        writer.print("}");
    }

    public static String getNumericFunctions() {
        return NUMERIC_FUNCTIONS;
    }

    public static String getStringFunctions() {
        return STRING_FUNCTIONS;
    }

    public static String getTimeDateFunctions() {
        return TIME_DATE_FUNCTIONS;
    }

    public static String getSystemFunctions() {
        return SYSTEM_FUNCTIONS;
    }

    private static class JdbcToInternalLookupTable {
        static final JdbcToInternalLookupTable INSTANCE = new JdbcToInternalLookupTable();
        private final Map<String, MakeCall> map;

        private JdbcToInternalLookupTable() {
            ImmutableMap.Builder<String, MakeCall> map = ImmutableMap.builder();
            map.put("ABS", this.simple(SqlStdOperatorTable.ABS));
            map.put("EXP", this.simple(SqlStdOperatorTable.EXP));
            map.put("LOG", this.simple(SqlStdOperatorTable.LN));
            map.put("LOG10", this.simple(SqlStdOperatorTable.LOG10));
            map.put("MOD", this.simple(SqlStdOperatorTable.MOD));
            map.put("POWER", this.simple(SqlStdOperatorTable.POWER));
            map.put("CONCAT", this.simple(SqlStdOperatorTable.CONCAT));
            map.put("INSERT", new PermutingMakeCall(SqlStdOperatorTable.OVERLAY, new int[]{0, 2, 3, 1}));
            map.put("LCASE", this.simple(SqlStdOperatorTable.LOWER));
            map.put("LENGTH", this.simple(SqlStdOperatorTable.CHARACTER_LENGTH));
            map.put("LOCATE", this.simple(SqlStdOperatorTable.POSITION));
            map.put("LTRIM", new SimpleMakeCall(SqlStdOperatorTable.TRIM){

                @Override
                public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
                    assert (1 == operands.length);
                    return super.createCall(pos, SqlTrimFunction.Flag.LEADING.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString(" ", null), operands[0]);
                }
            });
            map.put("QUARTER", this.simple(SqlStdOperatorTable.QUARTER));
            map.put("RTRIM", new SimpleMakeCall(SqlStdOperatorTable.TRIM){

                @Override
                public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
                    assert (1 == operands.length);
                    return super.createCall(pos, SqlTrimFunction.Flag.TRAILING.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString(" ", null), operands[0]);
                }
            });
            map.put("SUBSTRING", this.simple(SqlStdOperatorTable.SUBSTRING));
            map.put("UCASE", this.simple(SqlStdOperatorTable.UPPER));
            map.put("CURDATE", this.simple(SqlStdOperatorTable.CURRENT_DATE));
            map.put("CURTIME", this.simple(SqlStdOperatorTable.LOCALTIME));
            map.put("NOW", this.simple(SqlStdOperatorTable.CURRENT_TIMESTAMP));
            map.put("TIMESTAMPADD", this.simple(SqlStdOperatorTable.TIMESTAMP_ADD));
            map.put("TIMESTAMPDIFF", this.simple(SqlStdOperatorTable.TIMESTAMP_DIFF));
            this.map = map.build();
        }

        private MakeCall simple(SqlOperator operator) {
            return new SimpleMakeCall(operator);
        }

        public MakeCall lookup(String name) {
            return this.map.get(name);
        }
    }

    private static class PermutingMakeCall
    extends SimpleMakeCall {
        final int[] order;

        PermutingMakeCall(SqlOperator operator, int[] order) {
            super(operator);
            this.order = Preconditions.checkNotNull(order);
        }

        @Override
        public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
            return super.createCall(pos, this.reorder(operands));
        }

        @Override
        public String isValidArgCount(SqlCallBinding binding) {
            if (this.order.length == binding.getOperandCount()) {
                return null;
            }
            return this.getArgCountMismatchMsg(this.order.length);
        }

        private String getArgCountMismatchMsg(int ... possible) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < possible.length; ++i) {
                if (i > 0) {
                    ret.append(" or ");
                }
                ret.append(possible[i]);
            }
            ret.append(" parameter(s)");
            return ret.toString();
        }

        protected SqlNode[] reorder(SqlNode[] operands) {
            assert (operands.length == this.order.length);
            SqlNode[] newOrder = new SqlNode[operands.length];
            for (int i = 0; i < operands.length; ++i) {
                assert (operands[i] != null);
                int joyDivision = this.order[i];
                assert (newOrder[joyDivision] == null) : "mapping is not 1:1";
                newOrder[joyDivision] = operands[i];
            }
            return newOrder;
        }
    }

    public static class SimpleMakeCall
    implements MakeCall {
        final SqlOperator operator;

        public SimpleMakeCall(SqlOperator operator) {
            this.operator = operator;
        }

        @Override
        public SqlOperator getOperator() {
            return this.operator;
        }

        @Override
        public SqlCall createCall(SqlParserPos pos, SqlNode ... operands) {
            return this.operator.createCall(pos, operands);
        }

        @Override
        public String isValidArgCount(SqlCallBinding binding) {
            return null;
        }
    }

    private static interface MakeCall {
        public SqlCall createCall(SqlParserPos var1, SqlNode ... var2);

        public SqlOperator getOperator();

        public String isValidArgCount(SqlCallBinding var1);
    }
}

