/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;

public final class LogicalCorrelate
extends Correlate {
    public LogicalCorrelate(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        super(cluster, traitSet, left, right, correlationId, requiredColumns, joinType);
        assert (!CalcitePrepareImpl.DEBUG || this.isValid(Litmus.THROW));
    }

    @Deprecated
    public LogicalCorrelate(RelOptCluster cluster, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), left, right, correlationId, requiredColumns, joinType);
    }

    public LogicalCorrelate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs().get(0), input.getInputs().get(1), new CorrelationId((Integer)input.get("correlationId")), input.getBitSet("requiredColumns"), input.getEnum("joinType", SemiJoinType.class));
    }

    public static LogicalCorrelate create(RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE);
        return new LogicalCorrelate(cluster, traitSet, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public LogicalCorrelate copy(RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalCorrelate(this.getCluster(), traitSet, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }
}

