/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.calcite.jdbc.CachingCalciteSchema;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.MetadataSchema;
import org.apache.calcite.jdbc.SimpleCalciteSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.util.Compatible;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableSortedMap;
import org.apache.hive.com.google.common.collect.ImmutableSortedSet;
import org.apache.hive.com.google.common.collect.LinkedListMultimap;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.collect.Multimap;

public abstract class CalciteSchema {
    protected static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int c = o1.compareToIgnoreCase(o2);
            if (c == 0) {
                c = o1.compareTo(o2);
            }
            return c;
        }
    };
    private final CalciteSchema parent;
    public final Schema schema;
    public final String name;
    public final NavigableMap<String, TableEntry> tableMap = new TreeMap<String, TableEntry>(COMPARATOR);
    protected final Multimap<String, FunctionEntry> functionMap = LinkedListMultimap.create();
    protected final NavigableMap<String, LatticeEntry> latticeMap = new TreeMap<String, LatticeEntry>(COMPARATOR);
    protected final NavigableSet<String> functionNames = new TreeSet<String>(COMPARATOR);
    protected final NavigableMap<String, FunctionEntry> nullaryFunctionMap = new TreeMap<String, FunctionEntry>(COMPARATOR);
    protected final NavigableMap<String, CalciteSchema> subSchemaMap = new TreeMap<String, CalciteSchema>(COMPARATOR);
    private ImmutableList<ImmutableList<String>> path;

    CalciteSchema(CalciteSchema parent, Schema schema, String name) {
        this.parent = parent;
        this.schema = schema;
        this.name = name;
    }

    protected abstract CalciteSchema getImplicitSubSchema(String var1, boolean var2);

    protected abstract TableEntry getImplicitTable(String var1, boolean var2);

    protected abstract TableEntry getImplicitTableBasedOnNullaryFunction(String var1, boolean var2);

    protected abstract void addImplicitSubSchemaToBuilder(ImmutableSortedMap.Builder<String, CalciteSchema> var1);

    protected abstract void addImplicitTableToBuilder(ImmutableSortedSet.Builder<String> var1);

    protected abstract void addImplicitFunctionToBuilder(ImmutableList.Builder<Function> var1);

    protected abstract void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> var1);

    protected abstract void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> var1);

    protected abstract boolean isCacheEnabled();

    public abstract void setCache(boolean var1);

    protected TableEntryImpl tableEntry(String name, Table table) {
        return new TableEntryImpl(this, name, table, ImmutableList.of());
    }

    public TableEntry add(String tableName, Table table) {
        return this.add(tableName, table, ImmutableList.of());
    }

    public TableEntry add(String tableName, Table table, ImmutableList<String> sqls) {
        TableEntryImpl entry = new TableEntryImpl(this, tableName, table, sqls);
        this.tableMap.put(tableName, entry);
        return entry;
    }

    private FunctionEntry add(String name, Function function) {
        FunctionEntryImpl entry = new FunctionEntryImpl(this, name, function);
        this.functionMap.put(name, entry);
        this.functionNames.add(name);
        if (function.getParameters().isEmpty()) {
            this.nullaryFunctionMap.put(name, entry);
        }
        return entry;
    }

    private LatticeEntry add(String name, Lattice lattice) {
        if (this.latticeMap.containsKey(name)) {
            throw new RuntimeException("Duplicate lattice '" + name + "'");
        }
        LatticeEntryImpl entry = new LatticeEntryImpl(this, name, lattice);
        this.latticeMap.put(name, entry);
        return entry;
    }

    public CalciteSchema root() {
        CalciteSchema schema = this;
        while (schema.parent != null) {
            schema = schema.parent;
        }
        return schema;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public List<String> path(String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name != null) {
            list.add(name);
        }
        CalciteSchema s = this;
        while (s != null) {
            if (s.parent != null || !s.name.equals("")) {
                list.add(s.name);
            }
            s = s.parent;
        }
        return ImmutableList.copyOf(Lists.reverse(list));
    }

    public final CalciteSchema getSubSchema(String schemaName, boolean caseSensitive) {
        if (caseSensitive) {
            CalciteSchema entry = (CalciteSchema)this.subSchemaMap.get(schemaName);
            if (entry != null) {
                return entry;
            }
        } else {
            Iterator iterator = CalciteSchema.find(this.subSchemaMap, schemaName).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                return (CalciteSchema)entry.getValue();
            }
        }
        return this.getImplicitSubSchema(schemaName, caseSensitive);
    }

    public abstract CalciteSchema add(String var1, Schema var2);

    public final TableEntry getTableBySql(String sql) {
        for (TableEntry tableEntry : this.tableMap.values()) {
            if (!tableEntry.sqls.contains(sql)) continue;
            return tableEntry;
        }
        return null;
    }

    public final TableEntry getTable(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            TableEntry entry = (TableEntry)this.tableMap.get(tableName);
            if (entry != null) {
                return entry;
            }
        } else {
            Iterator iterator = CalciteSchema.find(this.tableMap, tableName).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                return (TableEntry)entry.getValue();
            }
        }
        return this.getImplicitTable(tableName, caseSensitive);
    }

    public String getName() {
        return this.name;
    }

    public SchemaPlus plus() {
        return new SchemaPlusImpl();
    }

    public static CalciteSchema from(SchemaPlus plus) {
        return ((SchemaPlusImpl)plus).calciteSchema();
    }

    public List<? extends List<String>> getPath() {
        if (this.path != null) {
            return this.path;
        }
        return ImmutableList.of(this.path(null));
    }

    public final NavigableMap<String, CalciteSchema> getSubSchemaMap() {
        ImmutableSortedMap.Builder<String, CalciteSchema> builder = new ImmutableSortedMap.Builder<String, CalciteSchema>(COMPARATOR);
        builder.putAll(this.subSchemaMap);
        this.addImplicitSubSchemaToBuilder(builder);
        return Compatible.INSTANCE.navigableMap(builder.build());
    }

    public NavigableMap<String, LatticeEntry> getLatticeMap() {
        return Compatible.INSTANCE.immutableNavigableMap(this.latticeMap);
    }

    public final NavigableSet<String> getTableNames() {
        ImmutableSortedSet.Builder<String> builder = new ImmutableSortedSet.Builder<String>(COMPARATOR);
        builder.addAll((Iterable)this.tableMap.keySet());
        this.addImplicitTableToBuilder(builder);
        return Compatible.INSTANCE.navigableSet(builder.build());
    }

    public final Collection<Function> getFunctions(String name, boolean caseSensitive) {
        ImmutableList.Builder<Function> builder = ImmutableList.builder();
        if (caseSensitive) {
            Collection<Function> functions;
            Collection<FunctionEntry> functionEntries = this.functionMap.get(name);
            if (functionEntries != null) {
                for (FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            if ((functions = this.schema.getFunctions(name)) != null) {
                builder.addAll(functions);
            }
        } else {
            for (String name2 : CalciteSchema.find(this.functionNames, name)) {
                Collection<FunctionEntry> functionEntries = this.functionMap.get(name2);
                if (functionEntries == null) continue;
                for (FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            this.addImplicitFunctionToBuilder(builder);
        }
        return builder.build();
    }

    public final NavigableSet<String> getFunctionNames() {
        ImmutableSortedSet.Builder<String> builder = new ImmutableSortedSet.Builder<String>(COMPARATOR);
        builder.addAll(this.functionMap.keySet());
        this.addImplicitFuncNamesToBuilder(builder);
        return Compatible.INSTANCE.navigableSet(builder.build());
    }

    public final NavigableMap<String, Table> getTablesBasedOnNullaryFunctions() {
        ImmutableSortedMap.Builder<String, Table> builder = new ImmutableSortedMap.Builder<String, Table>(COMPARATOR);
        for (Map.Entry s : this.nullaryFunctionMap.entrySet()) {
            Function function = ((FunctionEntry)s.getValue()).getFunction();
            if (!(function instanceof TableMacro)) continue;
            assert (function.getParameters().isEmpty());
            TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
            builder.put(s.getKey(), (Object)table);
        }
        this.addImplicitTablesBasedOnNullaryFunctionsToBuilder(builder);
        return Compatible.INSTANCE.navigableMap(builder.build());
    }

    public final TableEntry getTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            Object function;
            FunctionEntry functionEntry = (FunctionEntry)this.nullaryFunctionMap.get(tableName);
            if (functionEntry != null && (function = functionEntry.getFunction()) instanceof TableMacro) {
                assert (function.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
            for (Function function2 : this.schema.getFunctions(tableName)) {
                if (!(function2 instanceof TableMacro) || !function2.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function2).apply(ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        } else {
            for (Map.Entry entry : CalciteSchema.find(this.nullaryFunctionMap, tableName).entrySet()) {
                Function function = ((FunctionEntry)entry.getValue()).getFunction();
                if (!(function instanceof TableMacro)) continue;
                assert (function.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
            TableEntry tableEntry = this.getImplicitTableBasedOnNullaryFunction(tableName, false);
        }
        return null;
    }

    protected static <V> NavigableMap<String, V> find(NavigableMap<String, V> map, String s) {
        assert (map.comparator() == COMPARATOR);
        return map.subMap(s.toUpperCase(), true, s.toLowerCase(), true);
    }

    protected static Iterable<String> find(NavigableSet<String> set, String name) {
        assert (set.comparator() == COMPARATOR);
        return set.subSet(name.toUpperCase(), true, name.toLowerCase(), true);
    }

    public static CalciteSchema createRootSchema(boolean addMetadataSchema) {
        return CalciteSchema.createRootSchema(addMetadataSchema, true);
    }

    public static CalciteSchema createRootSchema(boolean addMetadataSchema, boolean cache) {
        CalciteConnectionImpl.RootSchema schema = new CalciteConnectionImpl.RootSchema();
        CalciteSchema rootSchema = cache ? new CachingCalciteSchema(null, schema, "") : new SimpleCalciteSchema(null, schema, "");
        if (addMetadataSchema) {
            rootSchema.add("metadata", MetadataSchema.INSTANCE);
        }
        return rootSchema;
    }

    public static class LatticeEntryImpl
    extends LatticeEntry {
        private final Lattice lattice;
        private final TableEntry starTableEntry;

        public LatticeEntryImpl(CalciteSchema schema, String name, Lattice lattice) {
            super(schema, name);
            this.lattice = lattice;
            StarTable starTable = lattice.createStarTable();
            this.starTableEntry = schema.add(name, starTable);
        }

        @Override
        public Lattice getLattice() {
            return this.lattice;
        }

        @Override
        public TableEntry getStarTable() {
            return this.starTableEntry;
        }
    }

    public static class FunctionEntryImpl
    extends FunctionEntry {
        private final Function function;

        public FunctionEntryImpl(CalciteSchema schema, String name, Function function) {
            super(schema, name);
            this.function = function;
        }

        @Override
        public Function getFunction() {
            return this.function;
        }

        @Override
        public boolean isMaterialization() {
            return this.function instanceof MaterializedViewTable.MaterializedViewTableMacro;
        }
    }

    public static class TableEntryImpl
    extends TableEntry {
        private final Table table;

        public TableEntryImpl(CalciteSchema schema, String name, Table table, ImmutableList<String> sqls) {
            super(schema, name, sqls);
            assert (table != null);
            this.table = Preconditions.checkNotNull(table);
        }

        @Override
        public Table getTable() {
            return this.table;
        }
    }

    private class SchemaPlusImpl
    implements SchemaPlus {
        private SchemaPlusImpl() {
        }

        CalciteSchema calciteSchema() {
            return CalciteSchema.this;
        }

        @Override
        public SchemaPlus getParentSchema() {
            return CalciteSchema.this.parent == null ? null : CalciteSchema.this.parent.plus();
        }

        @Override
        public String getName() {
            return CalciteSchema.this.getName();
        }

        @Override
        public boolean isMutable() {
            return CalciteSchema.this.schema.isMutable();
        }

        @Override
        public void setCacheEnabled(boolean cache) {
            CalciteSchema.this.setCache(cache);
        }

        @Override
        public boolean isCacheEnabled() {
            return CalciteSchema.this.isCacheEnabled();
        }

        @Override
        public boolean contentsHaveChangedSince(long lastCheck, long now) {
            return CalciteSchema.this.schema.contentsHaveChangedSince(lastCheck, now);
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return CalciteSchema.this.schema.getExpression(parentSchema, name);
        }

        @Override
        public Table getTable(String name) {
            TableEntry entry = CalciteSchema.this.getTable(name, true);
            return entry == null ? null : entry.getTable();
        }

        public NavigableSet<String> getTableNames() {
            return CalciteSchema.this.getTableNames();
        }

        @Override
        public Collection<Function> getFunctions(String name) {
            return CalciteSchema.this.getFunctions(name, true);
        }

        public NavigableSet<String> getFunctionNames() {
            return CalciteSchema.this.getFunctionNames();
        }

        @Override
        public SchemaPlus getSubSchema(String name) {
            CalciteSchema subSchema = CalciteSchema.this.getSubSchema(name, true);
            return subSchema == null ? null : subSchema.plus();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return CalciteSchema.this.getSubSchemaMap().keySet();
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            CalciteSchema calciteSchema = CalciteSchema.this.add(name, schema);
            return calciteSchema.plus();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            if (clazz.isInstance(CalciteSchema.this)) {
                return clazz.cast(CalciteSchema.this);
            }
            if (clazz.isInstance(CalciteSchema.this.schema)) {
                return clazz.cast(CalciteSchema.this.schema);
            }
            throw new ClassCastException("not a " + clazz);
        }

        @Override
        public void setPath(ImmutableList<ImmutableList<String>> path) {
            CalciteSchema.this.path = path;
        }

        @Override
        public void add(String name, Table table) {
            CalciteSchema.this.add(name, table);
        }

        @Override
        public void add(String name, Function function) {
            CalciteSchema.this.add(name, function);
        }

        @Override
        public void add(String name, Lattice lattice) {
            CalciteSchema.this.add(name, lattice);
        }
    }

    public static abstract class LatticeEntry
    extends Entry {
        public LatticeEntry(CalciteSchema schema, String name) {
            super(schema, name);
        }

        public abstract Lattice getLattice();

        public abstract TableEntry getStarTable();
    }

    public static abstract class FunctionEntry
    extends Entry {
        public FunctionEntry(CalciteSchema schema, String name) {
            super(schema, name);
        }

        public abstract Function getFunction();

        public abstract boolean isMaterialization();
    }

    public static abstract class TableEntry
    extends Entry {
        public final List<String> sqls;

        public TableEntry(CalciteSchema schema, String name, ImmutableList<String> sqls) {
            super(schema, name);
            this.sqls = Preconditions.checkNotNull(sqls);
        }

        public abstract Table getTable();
    }

    public static abstract class Entry {
        public final CalciteSchema schema;
        public final String name;

        public Entry(CalciteSchema schema, String name) {
            this.schema = Preconditions.checkNotNull(schema);
            this.name = Preconditions.checkNotNull(name);
        }

        public final List<String> path() {
            return this.schema.path(this.name);
        }
    }
}

