/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.orc.CompressionCodec;
import org.apache.orc.DataReader;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.DataReaderProperties;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.WriterImpl;

public class RecordReaderUtils {
    private static final HadoopShims SHIMS = HadoopShims.Factory.get();
    private static final int BYTE_STREAM_POSITIONS = 1;
    private static final int RUN_LENGTH_BYTE_POSITIONS = 2;
    private static final int BITFIELD_POSITIONS = 3;
    private static final int RUN_LENGTH_INT_POSITIONS = 2;
    static final int WORST_UNCOMPRESSED_SLOP = 4098;

    public static DataReader createDefaultDataReader(DataReaderProperties properties) {
        return new DefaultDataReader(properties);
    }

    public static boolean[] findPresentStreamsByColumn(List<OrcProto.Stream> streamList, List<OrcProto.Type> types) {
        boolean[] hasNull = new boolean[types.size()];
        for (OrcProto.Stream stream : streamList) {
            if (!stream.hasKind() || stream.getKind() != OrcProto.Stream.Kind.PRESENT) continue;
            hasNull[stream.getColumn()] = true;
        }
        return hasNull;
    }

    static boolean overlap(long leftA, long rightA, long leftB, long rightB) {
        if (leftA <= leftB) {
            return rightA >= leftB;
        }
        return rightB >= leftA;
    }

    public static void addEntireStreamToRanges(long offset, long length, DiskRangeList.CreateHelper list, boolean doMergeBuffers) {
        list.addOrMerge(offset, offset + length, doMergeBuffers, false);
    }

    public static void addRgFilteredStreamToRanges(OrcProto.Stream stream, boolean[] includedRowGroups, boolean isCompressed, OrcProto.RowIndex index, OrcProto.ColumnEncoding encoding, OrcProto.Type type, int compressionSize, boolean hasNull, long offset, long length, DiskRangeList.CreateHelper list, boolean doMergeBuffers) {
        for (int group = 0; group < includedRowGroups.length; ++group) {
            if (!includedRowGroups[group]) continue;
            int posn = RecordReaderUtils.getIndexPosition(encoding.getKind(), type.getKind(), stream.getKind(), isCompressed, hasNull);
            long start = index.getEntry(group).getPositions(posn);
            boolean isLast = group == includedRowGroups.length - 1;
            long nextGroupOffset = isLast ? length : index.getEntry(group + 1).getPositions(posn);
            long end = offset + RecordReaderUtils.estimateRgEndOffset(isCompressed, isLast, nextGroupOffset, length, compressionSize);
            list.addOrMerge(start += offset, end, doMergeBuffers, true);
        }
    }

    public static long estimateRgEndOffset(boolean isCompressed, boolean isLast, long nextGroupOffset, long streamLength, int bufferSize) {
        long slop = isCompressed ? (long)(2 * (3 + bufferSize)) : 4098L;
        return isLast ? streamLength : Math.min(streamLength, nextGroupOffset + slop);
    }

    public static int getIndexPosition(OrcProto.ColumnEncoding.Kind columnEncoding, OrcProto.Type.Kind columnType, OrcProto.Stream.Kind streamType, boolean isCompressed, boolean hasNulls) {
        if (streamType == OrcProto.Stream.Kind.PRESENT) {
            return 0;
        }
        int compressionValue = isCompressed ? 1 : 0;
        int base = hasNulls ? 3 + compressionValue : 0;
        switch (columnType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case STRUCT: 
            case MAP: 
            case LIST: 
            case UNION: {
                return base;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                if (columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY || columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                    return base;
                }
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case BINARY: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case DECIMAL: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case TIMESTAMP: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 2 + compressionValue;
            }
        }
        throw new IllegalArgumentException("Unknown type " + columnType);
    }

    public static boolean isDictionary(OrcProto.Stream.Kind kind, OrcProto.ColumnEncoding encoding) {
        assert (kind != OrcProto.Stream.Kind.DICTIONARY_COUNT);
        OrcProto.ColumnEncoding.Kind encodingKind = encoding.getKind();
        return kind == OrcProto.Stream.Kind.DICTIONARY_DATA || kind == OrcProto.Stream.Kind.LENGTH && (encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY || encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
    }

    public static String stringifyDiskRanges(DiskRangeList range) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean isFirst = true;
        while (range != null) {
            if (!isFirst) {
                buffer.append(", {");
            } else {
                buffer.append("{");
            }
            isFirst = false;
            buffer.append(range.toString());
            buffer.append("}");
            range = range.next;
        }
        buffer.append("]");
        return buffer.toString();
    }

    static DiskRangeList readDiskRanges(FSDataInputStream file, HadoopShims.ZeroCopyReaderShim zcr, long base, DiskRangeList range, boolean doForceDirect) throws IOException {
        if (range == null) {
            return null;
        }
        DiskRangeList prev = range.prev;
        if (prev == null) {
            prev = new DiskRangeList.MutateHelper(range);
        }
        while (range != null) {
            if (range.hasData()) {
                range = range.next;
                continue;
            }
            int len = (int)(range.getEnd() - range.getOffset());
            long off = range.getOffset();
            if (zcr != null) {
                file.seek(base + off);
                boolean hasReplaced = false;
                while (len > 0) {
                    ByteBuffer partial = zcr.readBuffer(len, false);
                    BufferChunk bc = new BufferChunk(partial, off);
                    if (!hasReplaced) {
                        range.replaceSelfWith(bc);
                        hasReplaced = true;
                    } else {
                        range.insertAfter(bc);
                    }
                    range = bc;
                    int read = partial.remaining();
                    len -= read;
                    off += (long)read;
                }
            } else {
                byte[] buffer = new byte[len];
                file.readFully(base + off, buffer, 0, buffer.length);
                ByteBuffer bb = null;
                if (doForceDirect) {
                    bb = ByteBuffer.allocateDirect(len);
                    bb.put(buffer);
                    bb.position(0);
                    bb.limit(len);
                } else {
                    bb = ByteBuffer.wrap(buffer);
                }
                range = range.replaceSelfWith(new BufferChunk(bb, range.getOffset()));
            }
            range = range.next;
        }
        return prev.next;
    }

    static List<DiskRange> getStreamBuffers(DiskRangeList range, long offset, long length) {
        ArrayList<DiskRange> buffers = new ArrayList<DiskRange>();
        if (length == 0L) {
            return buffers;
        }
        long streamEnd = offset + length;
        boolean inRange = false;
        while (range != null) {
            if (!inRange) {
                if (range.getEnd() <= offset) {
                    range = range.next;
                    continue;
                }
                inRange = true;
                if (range.getOffset() < offset) {
                    buffers.add(range.sliceAndShift(offset, Math.min(streamEnd, range.getEnd()), -offset));
                    if (range.getEnd() >= streamEnd) break;
                    range = range.next;
                    continue;
                }
            } else if (range.getOffset() >= streamEnd) break;
            if (range.getEnd() > streamEnd) {
                buffers.add(range.sliceAndShift(range.getOffset(), streamEnd, -offset));
                break;
            }
            buffers.add(range.sliceAndShift(range.getOffset(), range.getEnd(), -offset));
            if (range.getEnd() == streamEnd) break;
            range = range.next;
        }
        return buffers;
    }

    static HadoopShims.ZeroCopyReaderShim createZeroCopyShim(FSDataInputStream file, CompressionCodec codec, ByteBufferAllocatorPool pool) throws IOException {
        if (codec == null || codec instanceof DirectDecompressionCodec && ((DirectDecompressionCodec)codec).isAvailable()) {
            return SHIMS.getZeroCopyReader(file, pool);
        }
        return null;
    }

    public static final class ByteBufferAllocatorPool
    implements HadoopShims.ByteBufferPoolShim {
        private final TreeMap<Key, ByteBuffer> buffers = new TreeMap();
        private final TreeMap<Key, ByteBuffer> directBuffers = new TreeMap();
        private long currentGeneration = 0L;

        private final TreeMap<Key, ByteBuffer> getBufferTree(boolean direct) {
            return direct ? this.directBuffers : this.buffers;
        }

        public void clear() {
            this.buffers.clear();
            this.directBuffers.clear();
        }

        @Override
        public ByteBuffer getBuffer(boolean direct, int length) {
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(direct);
            Map.Entry<Key, ByteBuffer> entry = tree.ceilingEntry(new Key(length, 0L));
            if (entry == null) {
                return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
            }
            tree.remove(entry.getKey());
            return entry.getValue();
        }

        @Override
        public void putBuffer(ByteBuffer buffer) {
            Key key;
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(buffer.isDirect());
            while (tree.containsKey(key = new Key(buffer.capacity(), this.currentGeneration++))) {
            }
            tree.put(key, buffer);
        }

        private static final class Key
        implements Comparable<Key> {
            private final int capacity;
            private final long insertionGeneration;

            Key(int capacity, long insertionGeneration) {
                this.capacity = capacity;
                this.insertionGeneration = insertionGeneration;
            }

            @Override
            public int compareTo(Key other) {
                return ComparisonChain.start().compare(this.capacity, other.capacity).compare(this.insertionGeneration, other.insertionGeneration).result();
            }

            public boolean equals(Object rhs) {
                if (rhs == null) {
                    return false;
                }
                try {
                    Key o = (Key)rhs;
                    return this.compareTo(o) == 0;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }

            public int hashCode() {
                return new HashCodeBuilder().append(this.capacity).append(this.insertionGeneration).toHashCode();
            }
        }
    }

    private static class DefaultDataReader
    implements DataReader {
        private FSDataInputStream file = null;
        private final ByteBufferAllocatorPool pool;
        private HadoopShims.ZeroCopyReaderShim zcr = null;
        private final FileSystem fs;
        private final Path path;
        private final boolean useZeroCopy;
        private final CompressionCodec codec;
        private final int bufferSize;
        private final int typeCount;

        private DefaultDataReader(DefaultDataReader other) {
            this.pool = other.pool;
            this.bufferSize = other.bufferSize;
            this.typeCount = other.typeCount;
            this.fs = other.fs;
            this.path = other.path;
            this.useZeroCopy = other.useZeroCopy;
            this.codec = other.codec;
        }

        private DefaultDataReader(DataReaderProperties properties) {
            this.fs = properties.getFileSystem();
            this.path = properties.getPath();
            this.useZeroCopy = properties.getZeroCopy();
            this.codec = WriterImpl.createCodec(properties.getCompression());
            this.bufferSize = properties.getBufferSize();
            this.typeCount = properties.getTypeCount();
            this.pool = this.useZeroCopy ? new ByteBufferAllocatorPool() : null;
        }

        @Override
        public void open() throws IOException {
            this.file = this.fs.open(this.path);
            this.zcr = this.useZeroCopy ? RecordReaderUtils.createZeroCopyShim(this.file, this.codec, this.pool) : null;
        }

        public OrcIndex readRowIndex(StripeInformation stripe, OrcProto.StripeFooter footer, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
            if (this.file == null) {
                this.open();
            }
            if (footer == null) {
                footer = this.readStripeFooter(stripe);
            }
            if (indexes == null) {
                indexes = new OrcProto.RowIndex[this.typeCount];
            }
            if (bloomFilterIndices == null) {
                bloomFilterIndices = new OrcProto.BloomFilterIndex[this.typeCount];
            }
            long offset = stripe.getOffset();
            List<OrcProto.Stream> streams = footer.getStreamsList();
            for (int i = 0; i < streams.size(); ++i) {
                OrcProto.Stream stream = streams.get(i);
                OrcProto.Stream nextStream = null;
                if (i < streams.size() - 1) {
                    nextStream = streams.get(i + 1);
                }
                int col = stream.getColumn();
                int len = (int)stream.getLength();
                if (stream.hasKind() && stream.getKind() == OrcProto.Stream.Kind.ROW_INDEX) {
                    boolean readBloomFilter = false;
                    if (sargColumns != null && sargColumns[col] && nextStream.getKind() == OrcProto.Stream.Kind.BLOOM_FILTER) {
                        len = (int)((long)len + nextStream.getLength());
                        ++i;
                        readBloomFilter = true;
                    }
                    if ((included == null || included[col]) && indexes[col] == null) {
                        byte[] buffer = new byte[len];
                        this.file.readFully(offset, buffer, 0, buffer.length);
                        ByteBuffer bb = ByteBuffer.wrap(buffer);
                        indexes[col] = OrcProto.RowIndex.parseFrom(InStream.create("index", Lists.newArrayList(new BufferChunk(bb, 0L)), stream.getLength(), this.codec, this.bufferSize));
                        if (readBloomFilter) {
                            bb.position((int)stream.getLength());
                            bloomFilterIndices[col] = OrcProto.BloomFilterIndex.parseFrom(InStream.create("bloom_filter", Lists.newArrayList(new BufferChunk(bb, 0L)), nextStream.getLength(), this.codec, this.bufferSize));
                        }
                    }
                }
                offset += (long)len;
            }
            OrcIndex index = new OrcIndex(indexes, bloomFilterIndices);
            return index;
        }

        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            if (this.file == null) {
                this.open();
            }
            long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
            int tailLength = (int)stripe.getFooterLength();
            ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
            this.file.readFully(offset, tailBuf.array(), tailBuf.arrayOffset(), tailLength);
            return OrcProto.StripeFooter.parseFrom(InStream.createCodedInputStream("footer", Lists.newArrayList(new BufferChunk(tailBuf, 0L)), tailLength, this.codec, this.bufferSize));
        }

        @Override
        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            return RecordReaderUtils.readDiskRanges(this.file, this.zcr, baseOffset, range, doForceDirect);
        }

        @Override
        public void close() throws IOException {
            if (this.pool != null) {
                this.pool.clear();
            }
            try (HadoopShims.ZeroCopyReaderShim myZcr = this.zcr;){
                if (this.file != null) {
                    this.file.close();
                }
            }
        }

        @Override
        public boolean isTrackingDiskRanges() {
            return this.zcr != null;
        }

        @Override
        public void releaseBuffer(ByteBuffer buffer) {
            this.zcr.releaseBuffer(buffer);
        }

        public DataReader clone() {
            return new DefaultDataReader(this);
        }
    }
}

