/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CopyWork;

public class ExportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private ReplicationSpec replicationSpec;

    public ExportSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        BaseSemanticAnalyzer.TableSpec ts;
        Tree tableTree = ast.getChild(0);
        Tree toTree = ast.getChild(1);
        this.replicationSpec = ast.getChildCount() > 2 ? new ReplicationSpec((ASTNode)ast.getChild(2)) : new ReplicationSpec();
        String tmpPath = ExportSemanticAnalyzer.stripQuotes(toTree.getText());
        URI toURI = EximUtil.getValidatedURI(this.conf, tmpPath);
        try {
            ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, (ASTNode)tableTree, false, true);
        }
        catch (SemanticException sme) {
            if (this.replicationSpec.isInReplicationScope() && (sme.getCause() instanceof InvalidTableException || sme instanceof Table.ValidationFailureSemanticException)) {
                ts = null;
            }
            throw sme;
        }
        if (ts != null) {
            try {
                EximUtil.validateTable(ts.tableHandle);
                if (this.replicationSpec.isInReplicationScope() && ts.tableHandle.isTemporary()) {
                    ts = null;
                }
            }
            catch (SemanticException e) {
                if (this.replicationSpec.isInReplicationScope()) {
                    ts = null;
                }
                throw e;
            }
        }
        try {
            FileSystem fs = FileSystem.get((URI)toURI, (Configuration)this.conf);
            Path toPath = new Path(toURI.getScheme(), toURI.getAuthority(), toURI.getPath());
            try {
                FileStatus tgt = fs.getFileStatus(toPath);
                if (!tgt.isDir()) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "Target is not a directory : " + toURI));
                }
                FileStatus[] files = fs.listStatus(toPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
                if (files != null && files.length != 0) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "Target is not an empty directory : " + toURI));
                }
            }
            catch (FileNotFoundException tgt) {}
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast), e);
        }
        PartitionIterable partitions = null;
        try {
            this.replicationSpec.setCurrentReplicationState(String.valueOf(this.db.getMSC().getCurrentNotificationEventId().getEventId()));
            partitions = ts != null && ts.tableHandle.isPartitioned() ? (ts.specType == BaseSemanticAnalyzer.TableSpec.SpecType.TABLE_ONLY ? (this.replicationSpec.isMetadataOnly() ? null : new PartitionIterable(this.db, ts.tableHandle, null, this.conf.getIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX))) : new PartitionIterable(ts.partitions)) : null;
            Path path = new Path(this.ctx.getLocalTmpPath(), "_metadata");
            EximUtil.createExportDump((FileSystem)FileSystem.getLocal((Configuration)this.conf), path, ts != null ? ts.tableHandle : null, partitions, this.replicationSpec);
            Task<CopyWork> rTask = TaskFactory.get(new CopyWork(path, new Path(toURI), false), this.conf, new Task[0]);
            this.rootTasks.add(rTask);
            this.LOG.debug("_metadata file written into " + path.toString() + " and then copied to " + toURI.toString());
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg("Exception while writing out the local file"), e);
        }
        if (!this.replicationSpec.isMetadataOnly() && ts != null) {
            Path parentPath = new Path(toURI);
            if (ts.tableHandle.isPartitioned()) {
                for (Partition partition : partitions) {
                    Path fromPath = partition.getDataLocation();
                    Path toPartPath = new Path(parentPath, partition.getName());
                    Task<CopyWork> rTask = TaskFactory.get(new CopyWork(fromPath, toPartPath, false), this.conf, new Task[0]);
                    this.rootTasks.add(rTask);
                    this.inputs.add(new ReadEntity(partition));
                }
            } else {
                Path fromPath = ts.tableHandle.getDataLocation();
                Path toDataPath = new Path(parentPath, "data");
                Task<CopyWork> rTask = TaskFactory.get(new CopyWork(fromPath, toDataPath, false), this.conf, new Task[0]);
                this.rootTasks.add(rTask);
                this.inputs.add(new ReadEntity(ts.tableHandle));
            }
            this.outputs.add(this.toWriteEntity(parentPath));
        }
    }
}

