/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdParallelism;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public class HiveRelMdParallelism
extends RelMdParallelism {
    private final Double maxSplitSize;

    public HiveRelMdParallelism(Double maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    public RelMetadataProvider getMetadataProvider() {
        return ReflectiveRelMetadataProvider.reflectiveSource((Object)((Object)this), (Method[])new Method[]{BuiltInMethod.IS_PHASE_TRANSITION.method, BuiltInMethod.SPLIT_COUNT.method});
    }

    public Boolean isPhaseTransition(HiveJoin join) {
        return join.isPhaseTransition();
    }

    public Boolean isPhaseTransition(HiveSortLimit sort) {
        return true;
    }

    public Integer splitCount(HiveJoin join) {
        return join.getSplitCount();
    }

    public Integer splitCount(HiveTableScan scan) {
        Integer splitCount;
        RelOptHiveTable table = (RelOptHiveTable)scan.getTable();
        List<String> bucketCols = table.getHiveTableMD().getBucketCols();
        if (bucketCols != null && !bucketCols.isEmpty()) {
            splitCount = table.getHiveTableMD().getNumBuckets();
        } else {
            splitCount = this.splitCountRepartition(scan);
            if (splitCount == null) {
                throw new RuntimeException("Could not get split count for table: " + scan.getTable().getQualifiedName());
            }
        }
        return splitCount;
    }

    public Integer splitCount(RelNode rel) {
        Boolean newPhase = RelMetadataQuery.isPhaseTransition((RelNode)rel);
        if (newPhase == null) {
            return null;
        }
        if (newPhase.booleanValue()) {
            return this.splitCountRepartition(rel);
        }
        Integer splitCount = 0;
        for (RelNode input : rel.getInputs()) {
            splitCount = splitCount + RelMetadataQuery.splitCount((RelNode)input);
        }
        return splitCount;
    }

    public Integer splitCountRepartition(RelNode rel) {
        Double averageRowSize = RelMetadataQuery.getAverageRowSize((RelNode)rel);
        Double rowCount = RelMetadataQuery.getRowCount((RelNode)rel);
        if (averageRowSize == null || rowCount == null) {
            return null;
        }
        Double totalSize = averageRowSize * rowCount;
        Double splitCount = totalSize / this.maxSplitSize;
        return splitCount.intValue();
    }
}

