/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class DoubleScalarLessEqualTimestampColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private double value;
    private int outputColumn;

    public DoubleScalarLessEqualTimestampColumn(double value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
    }

    public DoubleScalarLessEqualTimestampColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        boolean[] outNulls = outputColVector.isNull;
        int n = batch.size;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        outputColVector.noNulls = inputColVector.noNulls;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = this.value <= inputColVector.getDouble(0) ? 1L : 0L;
                outputColVector.isRepeating = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.value <= inputColVector.getDouble(i) ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.value <= inputColVector.getDouble(i) ? 1L : 0L;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = this.value <= inputColVector.getDouble(0) ? 1L : 0L;
                outNulls[0] = false;
            } else {
                outNulls[0] = true;
            }
            outputColVector.isRepeating = true;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!nullPos[i]) {
                    outputVector[i] = this.value <= inputColVector.getDouble(i) ? 1L : 0L;
                    outNulls[i] = false;
                    continue;
                }
                outNulls[i] = true;
            }
        } else {
            System.arraycopy(nullPos, 0, outNulls, 0, n);
            for (int i = 0; i != n; ++i) {
                if (nullPos[i]) continue;
                outputVector[i] = this.value <= inputColVector.getDouble(i) ? 1L : 0L;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("timestamp")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

