/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.statistics;

import java.util.Arrays;
import parquet.column.UnknownColumnTypeException;
import parquet.column.statistics.BinaryStatistics;
import parquet.column.statistics.BooleanStatistics;
import parquet.column.statistics.DoubleStatistics;
import parquet.column.statistics.FloatStatistics;
import parquet.column.statistics.IntStatistics;
import parquet.column.statistics.LongStatistics;
import parquet.column.statistics.StatisticsClassException;
import parquet.io.api.Binary;
import parquet.schema.PrimitiveType;

public abstract class Statistics<T extends Comparable<T>> {
    private boolean hasNonNullValue = false;
    private long num_nulls = 0L;

    public static Statistics getStatsBasedOnType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT32: {
                return new IntStatistics();
            }
            case INT64: {
                return new LongStatistics();
            }
            case FLOAT: {
                return new FloatStatistics();
            }
            case DOUBLE: {
                return new DoubleStatistics();
            }
            case BOOLEAN: {
                return new BooleanStatistics();
            }
            case BINARY: {
                return new BinaryStatistics();
            }
            case INT96: {
                return new BinaryStatistics();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new BinaryStatistics();
            }
        }
        throw new UnknownColumnTypeException(type);
    }

    public static Builder getBuilderForReading(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case FLOAT: {
                return new FloatBuilder(type);
            }
            case DOUBLE: {
                return new DoubleBuilder(type);
            }
        }
        return new Builder(type);
    }

    public void updateStats(int value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(float value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(double value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(boolean value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(Binary value) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Statistics)) {
            return false;
        }
        Statistics stats = (Statistics)other;
        return Arrays.equals(stats.getMaxBytes(), this.getMaxBytes()) && Arrays.equals(stats.getMinBytes(), this.getMinBytes()) && stats.getNumNulls() == this.getNumNulls();
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.getMaxBytes()) + 17 * Arrays.hashCode(this.getMinBytes()) + Long.valueOf(this.getNumNulls()).hashCode();
    }

    public void mergeStatistics(Statistics stats) {
        if (stats.isEmpty()) {
            return;
        }
        if (this.getClass() == stats.getClass()) {
            this.incrementNumNulls(stats.getNumNulls());
            if (stats.hasNonNullValue()) {
                this.mergeStatisticsMinMax(stats);
                this.markAsNotEmpty();
            }
        } else {
            throw new StatisticsClassException(this.getClass().toString(), stats.getClass().toString());
        }
    }

    protected abstract void mergeStatisticsMinMax(Statistics var1);

    public abstract void setMinMaxFromBytes(byte[] var1, byte[] var2);

    public abstract T genericGetMin();

    public abstract T genericGetMax();

    public abstract byte[] getMaxBytes();

    public abstract byte[] getMinBytes();

    public abstract boolean isSmallerThan(long var1);

    public abstract String toString();

    public void incrementNumNulls() {
        ++this.num_nulls;
    }

    public void incrementNumNulls(long increment) {
        this.num_nulls += increment;
    }

    public long getNumNulls() {
        return this.num_nulls;
    }

    public void setNumNulls(long nulls) {
        this.num_nulls = nulls;
    }

    public boolean isEmpty() {
        return !this.hasNonNullValue && !this.isNumNullsSet();
    }

    public boolean hasNonNullValue() {
        return this.hasNonNullValue;
    }

    public boolean isNumNullsSet() {
        return this.num_nulls >= 0L;
    }

    protected void markAsNotEmpty() {
        this.hasNonNullValue = true;
    }

    private static class DoubleBuilder
    extends Builder {
        public DoubleBuilder(PrimitiveType.PrimitiveTypeName type) {
            super(type);
            assert (type == PrimitiveType.PrimitiveTypeName.DOUBLE);
        }

        @Override
        public Statistics<?> build() {
            DoubleStatistics stats = (DoubleStatistics)super.build();
            if (stats.hasNonNullValue()) {
                Double min = stats.genericGetMin();
                Double max = stats.genericGetMax();
                if (min.isNaN() || max.isNaN()) {
                    stats.setMinMax(0.0, 0.0);
                    ((Statistics)stats).hasNonNullValue = false;
                } else {
                    if (Double.compare(min, 0.0) == 0) {
                        min = -0.0;
                        stats.setMinMax(min, max);
                    }
                    if (Double.compare(max, -0.0) == 0) {
                        max = 0.0;
                        stats.setMinMax(min, max);
                    }
                }
            }
            return stats;
        }
    }

    private static class FloatBuilder
    extends Builder {
        public FloatBuilder(PrimitiveType.PrimitiveTypeName type) {
            super(type);
            assert (type == PrimitiveType.PrimitiveTypeName.FLOAT);
        }

        @Override
        public Statistics<?> build() {
            FloatStatistics stats = (FloatStatistics)super.build();
            if (stats.hasNonNullValue()) {
                Float min = stats.genericGetMin();
                Float max = stats.genericGetMax();
                if (min.isNaN() || max.isNaN()) {
                    stats.setMinMax(0.0f, 0.0f);
                    ((Statistics)stats).hasNonNullValue = false;
                } else {
                    if (Float.compare(min.floatValue(), 0.0f) == 0) {
                        min = Float.valueOf(-0.0f);
                        stats.setMinMax(min.floatValue(), max.floatValue());
                    }
                    if (Float.compare(max.floatValue(), -0.0f) == 0) {
                        max = Float.valueOf(0.0f);
                        stats.setMinMax(min.floatValue(), max.floatValue());
                    }
                }
            }
            return stats;
        }
    }

    public static class Builder {
        private final PrimitiveType.PrimitiveTypeName type;
        private byte[] min;
        private byte[] max;
        private long numNulls = -1L;

        private Builder(PrimitiveType.PrimitiveTypeName type) {
            this.type = type;
        }

        public Builder withMin(byte[] min) {
            this.min = min;
            return this;
        }

        public Builder withMax(byte[] max) {
            this.max = max;
            return this;
        }

        public Builder withNumNulls(long numNulls) {
            this.numNulls = numNulls;
            return this;
        }

        public Statistics build() {
            Statistics stats = Statistics.getStatsBasedOnType(this.type);
            if (this.min != null && this.max != null) {
                stats.setMinMaxFromBytes(this.min, this.max);
            }
            stats.num_nulls = this.numNulls;
            return stats;
        }
    }
}

