/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;

public class DfsProcessor
implements CommandProcessor {
    public static final Log LOG = LogFactory.getLog((String)DfsProcessor.class.getName());
    public static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    public static final String DFS_RESULT_HEADER = "DFS Output";
    private final FsShell dfs;
    private final Schema dfsSchema;

    public DfsProcessor(Configuration conf) {
        this(conf, false);
    }

    public DfsProcessor(Configuration conf, boolean addSchema) {
        this.dfs = new FsShell(conf);
        this.dfsSchema = new Schema();
        this.dfsSchema.addToFieldSchemas(new FieldSchema(DFS_RESULT_HEADER, "string", ""));
    }

    @Override
    public void init() {
    }

    @Override
    public CommandProcessorResponse run(String command) {
        try {
            int ret;
            SessionState ss = SessionState.get();
            command = new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), command);
            String[] tokens = command.split("\\s+");
            CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.DFS, Arrays.asList(tokens));
            if (authErrResp != null) {
                return authErrResp;
            }
            PrintStream oldOut = System.out;
            if (ss != null && ss.out != null) {
                System.setOut(ss.out);
            }
            if ((ret = this.dfs.run(tokens)) != 0) {
                console.printError("Command " + command + " failed with exit code = " + ret);
            }
            System.setOut(oldOut);
            return new CommandProcessorResponse(ret, null, null, this.dfsSchema);
        }
        catch (Exception e) {
            console.printError("Exception raised from DFSShell.run " + e.getLocalizedMessage(), StringUtils.stringifyException((Throwable)e));
            return new CommandProcessorResponse(1);
        }
    }
}

