/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkSortMergeJoinFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.parse.spark.SparkSMBMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class GenSparkUtils {
    private static final Log LOG = LogFactory.getLog((String)GenSparkUtils.class.getName());
    private int sequenceNumber = 0;
    private static GenSparkUtils utils;

    public static GenSparkUtils getUtils() {
        if (utils == null) {
            utils = new GenSparkUtils();
        }
        return utils;
    }

    protected GenSparkUtils() {
    }

    public void resetSequenceNumber() {
        this.sequenceNumber = 0;
    }

    public ReduceWork createReduceWork(GenSparkProcContext context, Operator<?> root, SparkWork sparkWork) throws SemanticException {
        Preconditions.checkArgument(!root.getParentOperators().isEmpty(), "AssertionError: expected root.getParentOperators() to be non-empty");
        ReduceWork reduceWork = new ReduceWork("Reducer " + ++this.sequenceNumber);
        LOG.debug((Object)("Adding reduce work (" + reduceWork.getName() + ") for " + root));
        reduceWork.setReducer(root);
        reduceWork.setNeedsTagging(GenMapRedUtils.needsTagging(reduceWork));
        Preconditions.checkArgument(context.parentOfRoot instanceof ReduceSinkOperator, "AssertionError: expected context.parentOfRoot to be an instance of ReduceSinkOperator, but was " + context.parentOfRoot.getClass().getName());
        ReduceSinkOperator reduceSink = (ReduceSinkOperator)context.parentOfRoot;
        reduceWork.setNumReduceTasks(((ReduceSinkDesc)reduceSink.getConf()).getNumReducers());
        this.setupReduceSink(context, reduceWork, reduceSink);
        sparkWork.add(reduceWork);
        SparkEdgeProperty edgeProp = GenSparkUtils.getEdgeProperty(context.conf, reduceSink, reduceWork);
        sparkWork.connect(context.preceedingWork, reduceWork, edgeProp);
        return reduceWork;
    }

    protected void setupReduceSink(GenSparkProcContext context, ReduceWork reduceWork, ReduceSinkOperator reduceSink) {
        LOG.debug((Object)("Setting up reduce sink: " + reduceSink + " with following reduce work: " + reduceWork.getName()));
        GenMapRedUtils.setKeyAndValueDesc(reduceWork, reduceSink);
        reduceWork.getTagToInput().put(((ReduceSinkDesc)reduceSink.getConf()).getTag(), context.preceedingWork.getName());
        ((ReduceSinkDesc)reduceSink.getConf()).setOutputName(reduceWork.getName());
    }

    public MapWork createMapWork(GenSparkProcContext context, Operator<?> root, SparkWork sparkWork, PrunedPartitionList partitions) throws SemanticException {
        return this.createMapWork(context, root, sparkWork, partitions, false);
    }

    public MapWork createMapWork(GenSparkProcContext context, Operator<?> root, SparkWork sparkWork, PrunedPartitionList partitions, boolean deferSetup) throws SemanticException {
        Preconditions.checkArgument(root.getParentOperators().isEmpty(), "AssertionError: expected root.getParentOperators() to be empty");
        MapWork mapWork = new MapWork("Map " + ++this.sequenceNumber);
        LOG.debug((Object)("Adding map work (" + mapWork.getName() + ") for " + root));
        Preconditions.checkArgument(root instanceof TableScanOperator, "AssertionError: expected root to be an instance of TableScanOperator, but was " + root.getClass().getName());
        String alias_id = null;
        if (context.parseContext != null && context.parseContext.getTopOps() != null) {
            for (String currentAliasID : context.parseContext.getTopOps().keySet()) {
                Operator<? extends OperatorDesc> currOp = context.parseContext.getTopOps().get(currentAliasID);
                if (currOp != root) continue;
                alias_id = currentAliasID;
                break;
            }
        }
        if (alias_id == null) {
            alias_id = ((TableScanDesc)((TableScanOperator)root).getConf()).getAlias();
        }
        if (!deferSetup) {
            this.setupMapWork(mapWork, context, partitions, root, alias_id);
        }
        sparkWork.add(mapWork);
        return mapWork;
    }

    protected void setupMapWork(MapWork mapWork, GenSparkProcContext context, PrunedPartitionList partitions, Operator<? extends OperatorDesc> root, String alias_id) throws SemanticException {
        GenMapRedUtils.setMapWork(mapWork, context.parseContext, context.inputs, partitions, root, alias_id, context.conf, false);
    }

    private void collectOperators(Operator<?> op, List<Operator<?>> opList) {
        opList.add(op);
        for (Operator<OperatorDesc> child : op.getChildOperators()) {
            if (child == null) continue;
            this.collectOperators(child, opList);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeUnionOperators(Configuration conf, GenSparkProcContext context, BaseWork work) throws SemanticException {
        ArrayList roots = new ArrayList();
        if (work instanceof MapWork) {
            roots.addAll(((MapWork)work).getAliasToWork().values());
        } else {
            roots.addAll(work.getAllRootOperators());
        }
        if (work.getDummyOps() != null) {
            roots.addAll(work.getDummyOps());
        }
        List<Operator<?>> newRoots = Utilities.cloneOperatorTree(conf, roots);
        Iterator<Operator<?>> newRootsIt = newRoots.iterator();
        for (Operator operator : roots) {
            Operator<?> newRoot = newRootsIt.next();
            LinkedList newOpQueue = new LinkedList();
            this.collectOperators(newRoot, newOpQueue);
            LinkedList linkedList = new LinkedList();
            this.collectOperators(operator, linkedList);
            Iterator newOpQueueIt = newOpQueue.iterator();
            for (Operator operator2 : linkedList) {
                Operator newOp = (Operator)newOpQueueIt.next();
                if (context.rootToWorkMap.containsKey(operator2)) {
                    context.rootToWorkMap.put(newOp, context.rootToWorkMap.get(operator2));
                }
                if (operator2 instanceof FileSinkOperator) {
                    List<FileSinkOperator> fileSinkList = context.fileSinkMap.get(operator2);
                    if (fileSinkList == null) {
                        fileSinkList = new LinkedList<FileSinkOperator>();
                    }
                    fileSinkList.add((FileSinkOperator)newOp);
                    context.fileSinkMap.put((FileSinkOperator)operator2, fileSinkList);
                    continue;
                }
                if (!(operator2 instanceof SparkPartitionPruningSinkOperator)) continue;
                SparkPartitionPruningSinkOperator oldPruningSink = (SparkPartitionPruningSinkOperator)operator2;
                SparkPartitionPruningSinkOperator newPruningSink = (SparkPartitionPruningSinkOperator)newOp;
                ((SparkPartitionPruningSinkDesc)newPruningSink.getConf()).setTableScan(((SparkPartitionPruningSinkDesc)oldPruningSink.getConf()).getTableScan());
                context.pruningSinkSet.add(newPruningSink);
                context.pruningSinkSet.remove(oldPruningSink);
            }
        }
        HashMap replacementMap = new HashMap();
        LinkedList<HashTableDummyOperator> linkedList = new LinkedList<HashTableDummyOperator>();
        Iterator<Operator<?>> it = newRoots.iterator();
        for (Operator operator : roots) {
            Set<FileSinkOperator> fsOpSet = OperatorUtils.findOperators(operator, FileSinkOperator.class);
            for (FileSinkOperator fileSinkOperator : fsOpSet) {
                context.fileSinkSet.remove(fileSinkOperator);
            }
            Operator<?> newRoot = it.next();
            if (newRoot instanceof HashTableDummyOperator) {
                linkedList.add((HashTableDummyOperator)newRoot);
                it.remove();
                continue;
            }
            replacementMap.put(operator, newRoot);
        }
        LinkedList operators = new LinkedList();
        operators.addAll(newRoots);
        HashSet<Operator> hashSet = new HashSet<Operator>();
        while (!operators.isEmpty()) {
            Operator current = (Operator)operators.pop();
            hashSet.add(current);
            if (current instanceof FileSinkOperator) {
                List<Object> linked;
                FileSinkOperator fileSink = (FileSinkOperator)current;
                context.fileSinkSet.add(fileSink);
                FileSinkDesc fileSinkDesc = (FileSinkDesc)fileSink.getConf();
                Path path = fileSinkDesc.getDirName();
                if (!context.linkedFileSinks.containsKey(path)) {
                    linked = new ArrayList();
                    context.linkedFileSinks.put(path, linked);
                }
                linked = context.linkedFileSinks.get(path);
                linked.add(fileSinkDesc);
                fileSinkDesc.setLinkedFileSinkDesc(linked);
            }
            if (current instanceof UnionOperator) {
                void var14_23;
                Operator<OperatorDesc> parent = null;
                boolean bl = false;
                for (Operator<OperatorDesc> op : current.getParentOperators()) {
                    if (!hashSet.contains(op)) continue;
                    ++var14_23;
                    parent = op;
                }
                Preconditions.checkArgument(var14_23 <= true, "AssertionError: expected count to be <= 1, but was " + (int)var14_23);
                if (parent == null) {
                    replacementMap.put(current, current.getChildOperators().get(0));
                } else {
                    parent.removeChildAndAdoptItsChildren(current);
                }
            }
            if (current instanceof FileSinkOperator || current instanceof ReduceSinkOperator) {
                current.setChildOperators(null);
                continue;
            }
            operators.addAll(current.getChildOperators());
        }
        work.setDummyOps(linkedList);
        work.replaceRoots(replacementMap);
    }

    public void processFileSink(GenSparkProcContext context, FileSinkOperator fileSink) throws SemanticException {
        FetchTask fetchTask;
        ParseContext parseContext = context.parseContext;
        boolean isInsertTable = GenMapRedUtils.isInsertInto(parseContext, fileSink);
        HiveConf hconf = parseContext.getConf();
        boolean chDir = GenMapRedUtils.isMergeRequired(context.moveTask, hconf, fileSink, context.currentTask, isInsertTable);
        List<FileSinkOperator> fileSinkList = context.fileSinkMap.get(fileSink);
        if (fileSinkList != null) {
            for (FileSinkOperator fsOp : fileSinkList) {
                ((FileSinkDesc)fsOp.getConf()).setGatherStats(((FileSinkDesc)fileSink.getConf()).isGatherStats());
                ((FileSinkDesc)fsOp.getConf()).setStatsReliable(((FileSinkDesc)fileSink.getConf()).isStatsReliable());
                ((FileSinkDesc)fsOp.getConf()).setMaxStatsKeyPrefixLength(((FileSinkDesc)fileSink.getConf()).getMaxStatsKeyPrefixLength());
            }
        }
        Path finalName = GenSparkUtils.createMoveTask(context.currentTask, chDir, fileSink, parseContext, context.moveTask, hconf, context.dependencyTask);
        if (chDir) {
            LOG.info((Object)"using CombineHiveInputformat for the merge job");
            GenMapRedUtils.createMRWorkForMergingFiles(fileSink, finalName, context.dependencyTask, context.moveTask, hconf, context.currentTask);
        }
        if ((fetchTask = parseContext.getFetchTask()) != null && context.currentTask.getNumChild() == 0 && fetchTask.isFetchFrom((FileSinkDesc)fileSink.getConf())) {
            context.currentTask.setFetchSource(true);
        }
    }

    public static Path createMoveTask(Task<? extends Serializable> currTask, boolean chDir, FileSinkOperator fsOp, ParseContext parseCtx, List<Task<MoveWork>> mvTasks, HiveConf hconf, DependencyCollectionTask dependencyTask) {
        Path dest = null;
        if (chDir) {
            dest = ((FileSinkDesc)fsOp.getConf()).getFinalDirName();
            Context baseCtx = parseCtx.getContext();
            Path tmpDir = baseCtx.getExternalTmpPath(dest);
            FileSinkDesc fileSinkDesc = (FileSinkDesc)fsOp.getConf();
            if (fileSinkDesc.getLinkedFileSinkDesc() != null) {
                for (FileSinkDesc fsConf : fileSinkDesc.getLinkedFileSinkDesc()) {
                    fsConf.setDirName(tmpDir);
                }
            } else {
                fileSinkDesc.setDirName(tmpDir);
            }
        }
        Task<MoveWork> mvTask = null;
        if (!chDir) {
            mvTask = GenMapRedUtils.findMoveTask(mvTasks, fsOp);
        }
        if (mvTask != null) {
            GenMapRedUtils.addDependentMoveTasks(mvTask, hconf, currTask, dependencyTask);
        }
        return dest;
    }

    public void processPartitionPruningSink(GenSparkProcContext context, SparkPartitionPruningSinkOperator pruningSink) {
        SparkPartitionPruningSinkDesc desc = (SparkPartitionPruningSinkDesc)pruningSink.getConf();
        TableScanOperator ts = desc.getTableScan();
        MapWork targetWork = (MapWork)context.rootToWorkMap.get(ts);
        Preconditions.checkArgument(targetWork != null, "No targetWork found for tablescan " + ts);
        String targetId = SparkUtilities.getWorkId(targetWork);
        BaseWork sourceWork = this.getEnclosingWork(pruningSink, context);
        String sourceId = SparkUtilities.getWorkId(sourceWork);
        Path tmpPath = targetWork.getTmpPathForPartitionPruning();
        if (tmpPath == null) {
            Path baseTmpPath = context.parseContext.getContext().getMRTmpPath();
            tmpPath = SparkUtilities.generateTmpPathForPartitionPruning(baseTmpPath, targetId);
            targetWork.setTmpPathForPartitionPruning(tmpPath);
            LOG.info((Object)("Setting tmp path between source work and target work:\n" + tmpPath));
        }
        desc.setPath(new Path(tmpPath, sourceId));
        desc.setTargetMapWork(targetWork);
        if (!targetWork.getEventSourceTableDescMap().containsKey(sourceId)) {
            targetWork.getEventSourceTableDescMap().put(sourceId, new LinkedList());
        }
        List<TableDesc> tables = targetWork.getEventSourceTableDescMap().get(sourceId);
        tables.add(((SparkPartitionPruningSinkDesc)pruningSink.getConf()).getTable());
        if (!targetWork.getEventSourceColumnNameMap().containsKey(sourceId)) {
            targetWork.getEventSourceColumnNameMap().put(sourceId, new LinkedList());
        }
        List<String> columns = targetWork.getEventSourceColumnNameMap().get(sourceId);
        columns.add(desc.getTargetColumnName());
        if (!targetWork.getEventSourceColumnTypeMap().containsKey(sourceId)) {
            targetWork.getEventSourceColumnTypeMap().put(sourceId, new LinkedList());
        }
        List<String> columnTypes = targetWork.getEventSourceColumnTypeMap().get(sourceId);
        columnTypes.add(desc.getTargetColumnType());
        if (!targetWork.getEventSourcePartKeyExprMap().containsKey(sourceId)) {
            targetWork.getEventSourcePartKeyExprMap().put(sourceId, new LinkedList());
        }
        List<ExprNodeDesc> keys = targetWork.getEventSourcePartKeyExprMap().get(sourceId);
        keys.add(desc.getPartKey());
    }

    public static SparkEdgeProperty getEdgeProperty(HiveConf conf, ReduceSinkOperator reduceSink, ReduceWork reduceWork) throws SemanticException {
        String bucketCount;
        FileSinkOperator fso;
        boolean useSparkGroupBy = conf.getBoolVar(HiveConf.ConfVars.SPARK_USE_GROUPBY_SHUFFLE);
        SparkEdgeProperty edgeProperty = new SparkEdgeProperty(0L);
        edgeProperty.setNumPartitions(reduceWork.getNumReduceTasks());
        String sortOrder = Strings.nullToEmpty(((ReduceSinkDesc)reduceSink.getConf()).getOrder()).trim();
        if (GenSparkUtils.hasGBYOperator(reduceSink)) {
            edgeProperty.setShuffleGroup();
            if (!useSparkGroupBy || !sortOrder.isEmpty() && GenSparkUtils.groupByNeedParLevelOrder(reduceSink)) {
                if (!useSparkGroupBy) {
                    LOG.info((Object)"hive.spark.use.groupby.shuffle is off. Use repartition shuffle instead.");
                }
                edgeProperty.setMRShuffle();
            }
        }
        if (reduceWork.getReducer() instanceof JoinOperator) {
            edgeProperty.setMRShuffle();
        }
        if ((fso = GenSparkUtils.getChildOperator(reduceWork.getReducer(), FileSinkOperator.class)) != null && (bucketCount = ((FileSinkDesc)fso.getConf()).getTableInfo().getProperties().getProperty("bucket_count")) != null && Integer.valueOf(bucketCount) > 1) {
            edgeProperty.setMRShuffle();
        }
        if (edgeProperty.isShuffleNone() && !sortOrder.isEmpty()) {
            if ((((ReduceSinkDesc)reduceSink.getConf()).getPartitionCols() == null || ((ReduceSinkDesc)reduceSink.getConf()).getPartitionCols().isEmpty() || GenSparkUtils.isSame(((ReduceSinkDesc)reduceSink.getConf()).getPartitionCols(), ((ReduceSinkDesc)reduceSink.getConf()).getKeyCols())) && ((ReduceSinkDesc)reduceSink.getConf()).hasOrderBy()) {
                edgeProperty.setShuffleSort();
            } else {
                edgeProperty.setMRShuffle();
            }
        }
        if (edgeProperty.isShuffleNone()) {
            if (!useSparkGroupBy) {
                LOG.info((Object)"hive.spark.use.groupby.shuffle is off. Use repartition shuffle instead.");
                edgeProperty.setMRShuffle();
            } else {
                edgeProperty.setShuffleGroup();
            }
        }
        return edgeProperty;
    }

    private static boolean groupByNeedParLevelOrder(ReduceSinkOperator reduceSinkOperator) {
        if (((ReduceSinkDesc)reduceSinkOperator.getConf()).isEnforceSort()) {
            return true;
        }
        List<Operator<OperatorDesc>> children = reduceSinkOperator.getChildOperators();
        if (children != null && children.size() == 1 && children.get(0) instanceof GroupByOperator) {
            GroupByOperator child = (GroupByOperator)children.get(0);
            if (GenSparkUtils.isSame(((ReduceSinkDesc)reduceSinkOperator.getConf()).getKeyCols(), ((ReduceSinkDesc)reduceSinkOperator.getConf()).getPartitionCols()) && ((ReduceSinkDesc)reduceSinkOperator.getConf()).getKeyCols().size() == ((GroupByDesc)child.getConf()).getKeys().size()) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSame(List<ExprNodeDesc> list1, List<ExprNodeDesc> list2) {
        if (list1 != list2) {
            if (list1 != null && list2 != null) {
                if (list1.size() != list2.size()) {
                    return false;
                }
                for (int i = 0; i < list1.size(); ++i) {
                    if (list1.get(i).isSame(list2.get(i))) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static <T> T getChildOperator(Operator<?> root, Class<T> klazz) throws SemanticException {
        if (root == null) {
            return null;
        }
        HashSet visited = new HashSet();
        Stack stack = new Stack();
        stack.push(root);
        visited.add(root);
        while (!stack.isEmpty()) {
            Operator op = (Operator)stack.pop();
            if (klazz.isInstance(op)) {
                return (T)op;
            }
            List<Operator<OperatorDesc>> childOperators = op.getChildOperators();
            for (Operator<OperatorDesc> childOp : childOperators) {
                if (visited.contains(childOp)) continue;
                stack.push(childOp);
                visited.add(childOp);
            }
        }
        return null;
    }

    public void annotateMapWork(GenSparkProcContext context) throws SemanticException {
        for (SMBMapJoinOperator smbMapJoinOp : context.smbMapJoinCtxMap.keySet()) {
            SparkSMBMapJoinInfo smbMapJoinInfo = context.smbMapJoinCtxMap.get(smbMapJoinOp);
            MapWork work = smbMapJoinInfo.mapWork;
            SparkSortMergeJoinFactory.annotateMapWork(context, work, smbMapJoinOp, (TableScanOperator)smbMapJoinInfo.bigTableRootOp, false);
            for (Operator<?> smallTableRootOp : smbMapJoinInfo.smallTableRootOps) {
                SparkSortMergeJoinFactory.annotateMapWork(context, work, smbMapJoinOp, (TableScanOperator)smallTableRootOp, true);
            }
        }
    }

    public synchronized int getNextSeqNumber() {
        return ++this.sequenceNumber;
    }

    private static boolean hasGBYOperator(ReduceSinkOperator rs) {
        if (rs.getChildOperators().size() == 1) {
            if (rs.getChildOperators().get(0) instanceof GroupByOperator) {
                return true;
            }
            if (rs.getChildOperators().get(0) instanceof ForwardOperator) {
                for (Operator<OperatorDesc> grandChild : rs.getChildOperators().get(0).getChildOperators()) {
                    if (grandChild instanceof GroupByOperator) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public BaseWork getEnclosingWork(Operator<?> op, GenSparkProcContext procCtx) {
        ArrayList ops = new ArrayList();
        this.findRoots(op, ops);
        for (Operator operator : ops) {
            BaseWork work = procCtx.rootToWorkMap.get(operator);
            if (work == null) continue;
            return work;
        }
        return null;
    }

    private void findRoots(Operator<?> op, List<Operator<?>> ops) {
        List<Operator<OperatorDesc>> parents = op.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            ops.add(op);
            return;
        }
        for (Operator<OperatorDesc> p : parents) {
            this.findRoots(p, ops);
        }
    }

    public static void removeBranch(Operator<?> op) {
        Operator<?> child = op;
        Operator<Object> curr = op;
        while (curr.getChildOperators().size() <= 1) {
            child = curr;
            if (curr.getParentOperators() == null || curr.getParentOperators().isEmpty()) {
                return;
            }
            curr = curr.getParentOperators().get(0);
        }
        curr.removeChild(child);
    }
}

