/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

public class AuthorizationParseUtils {
    public static PrincipalDesc getPrincipalDesc(ASTNode principal) {
        PrincipalType type = AuthorizationParseUtils.getPrincipalType(principal);
        if (type != null) {
            String text = principal.getChild(0).getText();
            String principalName = BaseSemanticAnalyzer.unescapeIdentifier(text);
            return new PrincipalDesc(principalName, type);
        }
        return null;
    }

    private static PrincipalType getPrincipalType(ASTNode principal) {
        switch (principal.getType()) {
            case 897: {
                return PrincipalType.USER;
            }
            case 702: {
                return PrincipalType.GROUP;
            }
            case 801: {
                return PrincipalType.ROLE;
            }
        }
        return null;
    }

    public static List<PrincipalDesc> analyzePrincipalListDef(ASTNode node) {
        ArrayList<PrincipalDesc> principalList = new ArrayList<PrincipalDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            principalList.add(AuthorizationParseUtils.getPrincipalDesc((ASTNode)node.getChild(i)));
        }
        return principalList;
    }
}

