/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.JobCallable;
import org.apache.hive.hcatalog.templeton.JobRequestExecutor;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueStatusBean;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.TooManyRequestsException;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusDelegator
extends TempletonDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(StatusDelegator.class);
    private final String JOB_STATUS_EXECUTE_THREAD_PREFIX = "JobStatusExecute";
    private final String statusThreadId = Thread.currentThread().getName();
    private static JobRequestExecutor<QueueStatusBean> jobRequest = new JobRequestExecutor(JobRequestExecutor.JobRequestType.Status, "templeton.parallellism.job.status", "templeton.job.status.timeout");

    public StatusDelegator(AppConfig appConf) {
        super(appConf);
    }

    public QueueStatusBean run(String user, String id, boolean enableThreadPool) throws NotAuthorizedException, BadParam, IOException, InterruptedException, BusyException, TimeoutException, ExecutionException, TooManyRequestsException {
        if (jobRequest.isThreadPoolEnabled() && enableThreadPool) {
            return jobRequest.execute(this.getJobStatusCallableTask(user, id));
        }
        return this.getJobStatus(user, id);
    }

    private JobCallable<QueueStatusBean> getJobStatusCallableTask(final String user, final String id) {
        return new JobCallable<QueueStatusBean>(){

            @Override
            public QueueStatusBean execute() throws NotAuthorizedException, BadParam, IOException, InterruptedException, BusyException {
                Thread.currentThread().setName(String.format("%s-%s-%s", "JobStatusExecute", StatusDelegator.this.statusThreadId, Thread.currentThread().getId()));
                return StatusDelegator.this.getJobStatus(user, id);
            }
        };
    }

    public QueueStatusBean run(String user, String id) throws NotAuthorizedException, BadParam, IOException, InterruptedException, BusyException, TimeoutException, ExecutionException, TooManyRequestsException {
        return this.run(user, id, true);
    }

    public QueueStatusBean getJobStatus(String user, String id) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        HadoopShims.WebHCatJTShim tracker = null;
        JobState state = null;
        UserGroupInformation ugi = null;
        try {
            ugi = UgiFactory.getUgi(user);
            tracker = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, ugi);
            JobID jobid = StatusDelegator.StringToJobID(id);
            if (jobid == null) {
                throw new BadParam("Invalid jobid: " + id);
            }
            state = new JobState(id, Main.getAppConfigInstance());
            QueueStatusBean queueStatusBean = StatusDelegator.makeStatus(tracker, jobid, state);
            return queueStatusBean;
        }
        catch (IllegalStateException e) {
            throw new BadParam(e.getMessage());
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
            if (state != null) {
                state.close();
            }
            if (ugi != null) {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
        }
    }

    static QueueStatusBean makeStatus(HadoopShims.WebHCatJTShim tracker, JobID jobid, JobState state) throws BadParam, IOException {
        JobStatus status = tracker.getJobStatus(jobid);
        JobProfile profile = tracker.getJobProfile(jobid);
        if (status == null || profile == null) {
            throw new BadParam("Could not find job " + String.valueOf(jobid));
        }
        return new QueueStatusBean(state, status, profile);
    }

    public static JobID StringToJobID(String id) throws BadParam {
        try {
            return JobID.forName((String)id);
        }
        catch (IllegalArgumentException e) {
            throw new BadParam(e.getMessage());
        }
    }
}

