/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import org.apache.hadoop.hive.metastore.api.NotificationEvent;

public class HCatNotificationEvent {
    private long eventId;
    private int eventTime;
    private String eventType;
    private String dbName;
    private String tableName;
    private String message;

    public HCatNotificationEvent(NotificationEvent event) {
        this.eventId = event.getEventId();
        this.eventTime = event.getEventTime();
        this.eventType = event.getEventType();
        this.dbName = event.getDbName();
        this.tableName = event.getTableName();
        this.message = event.getMessage();
    }

    public long getEventId() {
        return this.eventId;
    }

    public Scope getEventScope() {
        if (this.dbName != null) {
            if (this.tableName != null) {
                return Scope.TABLE;
            }
            return Scope.DB;
        }
        return Scope.UNKNOWN;
    }

    public int getEventTime() {
        return this.eventTime;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("eventId:");
        buf.append(this.eventId);
        buf.append(" eventTime:");
        buf.append(this.eventTime);
        buf.append(" eventType:<");
        buf.append(this.eventType);
        buf.append("> dbName:<");
        buf.append(this.dbName);
        buf.append("> tableName:<");
        buf.append(this.tableName);
        buf.append("> message:<");
        buf.append(this.message);
        buf.append(">");
        return buf.toString();
    }

    public static enum Scope {
        DB,
        TABLE,
        UNKNOWN;

    }
}

