/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.common.HCatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatAddPartitionDesc {
    private static final Logger LOG = LoggerFactory.getLogger(HCatAddPartitionDesc.class);
    private String tableName;
    private String dbName;
    private String location;
    private Map<String, String> partSpec;

    private HCatAddPartitionDesc(String dbName, String tbl, String loc, Map<String, String> spec) {
        this.dbName = dbName;
        this.tableName = tbl;
        this.location = loc;
        this.partSpec = spec;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, String> getPartitionSpec() {
        return this.partSpec;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public String toString() {
        return "HCatAddPartitionDesc [" + (this.tableName != null ? "tableName=" + this.tableName + ", " : "tableName=null") + (this.dbName != null ? "dbName=" + this.dbName + ", " : "dbName=null") + (this.location != null ? "location=" + this.location + ", " : "location=null") + (this.partSpec != null ? "partSpec=" + this.partSpec : "partSpec=null") + "]";
    }

    public static Builder create(String dbName, String tableName, String location, Map<String, String> partSpec) throws HCatException {
        return new Builder(dbName, tableName, location, partSpec);
    }

    Partition toHivePartition(Table hiveTable) throws HCatException {
        Partition hivePtn = new Partition();
        hivePtn.setDbName(this.dbName);
        hivePtn.setTableName(this.tableName);
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : hiveTable.getPartitionKeys()) {
            String val = this.partSpec.get(field.getName());
            if (val == null || val.length() == 0) {
                throw new HCatException("create partition: Value for key " + field.getName() + " is null or empty");
            }
            pvals.add(val);
        }
        hivePtn.setValues(pvals);
        StorageDescriptor sd = new StorageDescriptor(hiveTable.getSd());
        hivePtn.setSd(sd);
        hivePtn.setParameters(hiveTable.getParameters());
        if (this.location != null) {
            hivePtn.getSd().setLocation(this.location);
        } else {
            String partName;
            try {
                partName = Warehouse.makePartName((List)hiveTable.getPartitionKeys(), pvals);
                LOG.info("Setting partition location to :" + partName);
            }
            catch (MetaException e) {
                throw new HCatException("Exception while creating partition name.", (Throwable)e);
            }
            Path partPath = new Path(hiveTable.getSd().getLocation(), partName);
            hivePtn.getSd().setLocation(partPath.toString());
        }
        hivePtn.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        hivePtn.setLastAccessTimeIsSet(false);
        return hivePtn;
    }

    public static class Builder {
        private String tableName;
        private String location;
        private Map<String, String> values;
        private String dbName;

        private Builder(String dbName, String tableName, String location, Map<String, String> values) {
            this.dbName = dbName;
            this.tableName = tableName;
            this.location = location;
            this.values = values;
        }

        public HCatAddPartitionDesc build() throws HCatException {
            if (this.dbName == null) {
                this.dbName = "default";
            }
            HCatAddPartitionDesc desc = new HCatAddPartitionDesc(this.dbName, this.tableName, this.location, this.values);
            return desc;
        }
    }
}

