/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class NettyFutureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NettyFutureUtils.class);

    private NettyFutureUtils() {
    }

    public static <V> void addListener(Future<V> future, GenericFutureListener<? extends Future<? super V>> listener) {
        future.addListener(f -> {
            try {
                listener.operationComplete(f);
            }
            catch (Throwable t) {
                LOG.error("Unexpected error caught when processing netty", t);
            }
        });
    }

    private static void loggingWhenError(Future<?> future) {
        if (!future.isSuccess()) {
            LOG.warn("IO operation failed", future.cause());
        }
    }

    public static void consume(Future<?> future) {
        future.addListener(NettyFutureUtils::loggingWhenError);
    }

    public static void safeClose(ChannelOutboundInvoker channel) {
        NettyFutureUtils.consume(channel.close());
    }

    public static void safeWrite(ChannelOutboundInvoker channel, Object msg) {
        NettyFutureUtils.consume(channel.write(msg));
    }

    public static void safeWriteAndFlush(ChannelOutboundInvoker channel, Object msg) {
        NettyFutureUtils.consume(channel.writeAndFlush(msg));
    }
}

