/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.cipher.OpenSslFeedbackCipher;
import org.apache.hadoop.hbase.shaded.org.apache.commons.crypto.cipher.OpenSslNative;

class OpenSslCommonMode
extends OpenSslFeedbackCipher {
    OpenSslCommonMode(long context, int algorithmMode, int padding) {
        super(context, algorithmMode, padding);
    }

    @Override
    public void init(int mode, byte[] key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.cipherMode = mode;
        if (!(params instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Illegal parameters");
        }
        byte[] iv = ((IvParameterSpec)params).getIV();
        this.context = OpenSslNative.init(this.context, mode, this.algorithmMode, this.padding, key, iv);
    }

    @Override
    public int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        this.checkState();
        int len = OpenSslNative.update(this.context, input, input.position(), input.remaining(), output, output.position(), output.remaining());
        input.position(input.limit());
        output.position(output.position() + len);
        return len;
    }

    @Override
    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.checkState();
        return OpenSslNative.updateByteArray(this.context, input, inputOffset, inputLen, output, outputOffset, output.length - outputOffset);
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkState();
        int len = OpenSslNative.updateByteArray(this.context, input, inputOffset, inputLen, output, outputOffset, output.length - outputOffset);
        len += OpenSslNative.doFinalByteArray(this.context, output, outputOffset + len, output.length - outputOffset - len);
        return len;
    }

    @Override
    public int doFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkState();
        int totalLen = 0;
        int len = OpenSslNative.update(this.context, input, input.position(), input.remaining(), output, output.position(), output.remaining());
        totalLen += len;
        input.position(input.limit());
        output.position(output.position() + len);
        len = OpenSslNative.doFinal(this.context, output, output.position(), output.remaining());
        output.position(output.position() + len);
        return totalLen += len;
    }

    @Override
    public void updateAAD(byte[] aad) {
        throw new UnsupportedOperationException("The underlying Cipher implementation does not support this method");
    }
}

