/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public enum DataBlockEncoding {
    NONE(0, null),
    PREFIX(2, "org.apache.hadoop.hbase.io.encoding.PrefixKeyDeltaEncoder"),
    DIFF(3, "org.apache.hadoop.hbase.io.encoding.DiffKeyDeltaEncoder"),
    FAST_DIFF(4, "org.apache.hadoop.hbase.io.encoding.FastDiffDeltaEncoder"),
    ROW_INDEX_V1(7, "org.apache.hadoop.hbase.io.encoding.RowIndexCodecV1");

    private final short id;
    private final byte[] idInBytes;
    private DataBlockEncoder encoder;
    private final String encoderCls;
    public static final int ID_SIZE = 2;
    private static DataBlockEncoding[] idArray;

    private DataBlockEncoding(int id, String encoderClsName) {
        if (id < 0 || id > 127) {
            throw new AssertionError((Object)("Data block encoding algorithm id is out of range: " + id));
        }
        this.id = (short)id;
        this.idInBytes = Bytes.toBytes(this.id);
        if (this.idInBytes.length != 2) {
            throw new RuntimeException("Unexpected length of encoder ID byte representation: " + Bytes.toStringBinary(this.idInBytes));
        }
        this.encoderCls = encoderClsName;
    }

    public byte[] getNameInBytes() {
        return Bytes.toBytes(this.toString());
    }

    public short getId() {
        return this.id;
    }

    public void writeIdInBytes(OutputStream stream) throws IOException {
        stream.write(this.idInBytes);
    }

    public void writeIdInBytes(byte[] dest, int offset) throws IOException {
        System.arraycopy(this.idInBytes, 0, dest, offset, 2);
    }

    public DataBlockEncoder getEncoder() {
        if (this.encoder == null && this.id != 0) {
            this.encoder = DataBlockEncoding.createEncoder(this.encoderCls);
        }
        return this.encoder;
    }

    public static DataBlockEncoder getDataBlockEncoderById(short encoderId) {
        return DataBlockEncoding.getEncodingById(encoderId).getEncoder();
    }

    public static String getNameFromId(short encoderId) {
        return DataBlockEncoding.getEncodingById(encoderId).toString();
    }

    public static boolean isCorrectEncoder(DataBlockEncoder encoder, short encoderId) {
        DataBlockEncoding algorithm = DataBlockEncoding.getEncodingById(encoderId);
        String encoderCls = encoder.getClass().getName();
        return encoderCls.equals(algorithm.encoderCls);
    }

    public static DataBlockEncoding getEncodingById(short dataBlockEncodingId) {
        DataBlockEncoding algorithm = null;
        if (dataBlockEncodingId >= 0 && dataBlockEncodingId <= 127) {
            algorithm = idArray[dataBlockEncodingId];
        }
        if (algorithm == null) {
            throw new IllegalArgumentException(String.format("There is no data block encoder for given id '%d'", dataBlockEncodingId));
        }
        return algorithm;
    }

    protected static DataBlockEncoder createEncoder(String fullyQualifiedClassName) {
        try {
            return (DataBlockEncoder)Class.forName(fullyQualifiedClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        idArray = new DataBlockEncoding[128];
        for (DataBlockEncoding algo : DataBlockEncoding.values()) {
            if (idArray[algo.id] != null) {
                throw new RuntimeException(String.format("Two data block encoder algorithms '%s' and '%s' have the same id %d", idArray[algo.id].toString(), algo.toString(), (int)algo.id));
            }
            DataBlockEncoding.idArray[algo.id] = algo;
        }
    }
}

