/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BlockCacheKey
implements HeapSize,
Serializable {
    private static final long serialVersionUID = -5199992013113130534L;
    private final String hfileName;
    private final long offset;
    private BlockType blockType;
    private final boolean isPrimaryReplicaBlock;
    private Path filePath;
    public static final long FIXED_OVERHEAD = ClassSize.estimateBase(BlockCacheKey.class, (boolean)false);

    public BlockCacheKey(String hfileName, long offset) {
        this(hfileName, offset, true, BlockType.DATA);
    }

    public BlockCacheKey(String hfileName, long offset, boolean isPrimaryReplica, BlockType blockType) {
        this.isPrimaryReplicaBlock = isPrimaryReplica;
        this.hfileName = hfileName;
        this.offset = offset;
        this.blockType = blockType;
    }

    public BlockCacheKey(Path hfilePath, long offset, boolean isPrimaryReplica, BlockType blockType) {
        this.filePath = hfilePath;
        this.isPrimaryReplicaBlock = isPrimaryReplica;
        this.hfileName = hfilePath.getName();
        this.offset = offset;
        this.blockType = blockType;
    }

    public int hashCode() {
        return this.hfileName.hashCode() * 127 + (int)(this.offset ^ this.offset >>> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof BlockCacheKey) {
            BlockCacheKey k = (BlockCacheKey)o;
            return this.offset == k.offset && (this.hfileName == null ? k.hfileName == null : this.hfileName.equals(k.hfileName));
        }
        return false;
    }

    public String toString() {
        return this.hfileName + '_' + this.offset;
    }

    public long heapSize() {
        return ClassSize.align((long)(FIXED_OVERHEAD + (long)ClassSize.STRING + (long)(2 * this.hfileName.length())));
    }

    public String getHfileName() {
        return this.hfileName;
    }

    public boolean isPrimary() {
        return this.isPrimaryReplicaBlock;
    }

    public long getOffset() {
        return this.offset;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public void setBlockType(BlockType blockType) {
        this.blockType = blockType;
    }

    public Path getFilePath() {
        return this.filePath;
    }
}

