/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileListFile;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerBase;
import org.apache.hadoop.hbase.shaded.protobuf.generated.StoreFileTrackerProtos;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class FileBasedStoreFileTracker
extends StoreFileTrackerBase {
    private final StoreFileListFile backedFile;
    private final Map<String, StoreFileInfo> storefiles = new HashMap<String, StoreFileInfo>();
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedStoreFileTracker.class);

    public FileBasedStoreFileTracker(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        super(conf, isPrimaryReplica, ctx);
        this.backedFile = ctx != null ? new StoreFileListFile(ctx) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<StoreFileInfo> doLoadStoreFiles(boolean readOnly) throws IOException {
        StoreFileTrackerProtos.StoreFileList list = this.backedFile.load(readOnly);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loaded file list backed file, containing " + list.getStoreFileList().size() + " store file entries");
        }
        if (list == null) {
            return Collections.emptyList();
        }
        FileSystem fs = this.ctx.getRegionFileSystem().getFileSystem();
        ArrayList<StoreFileInfo> infos = new ArrayList<StoreFileInfo>();
        for (StoreFileTrackerProtos.StoreFileEntry entry : list.getStoreFileList()) {
            infos.add(ServerRegionReplicaUtil.getStoreFileInfo(this.conf, fs, this.ctx.getRegionInfo(), this.ctx.getRegionFileSystem().getRegionInfoForFS(), this.ctx.getFamily().getNameAsString(), new Path(this.ctx.getFamilyStoreDirectoryPath(), entry.getName()), this));
        }
        Map<String, StoreFileInfo> map = this.storefiles;
        synchronized (map) {
            for (StoreFileInfo info : infos) {
                this.storefiles.put(info.getPath().getName(), info);
            }
        }
        return infos;
    }

    @Override
    public boolean requireWritingToTmpDirFirst() {
        return false;
    }

    private StoreFileTrackerProtos.StoreFileEntry toStoreFileEntry(StoreFileInfo info) {
        return StoreFileTrackerProtos.StoreFileEntry.newBuilder().setName(info.getPath().getName()).setSize(info.getSize()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAddNewStoreFiles(Collection<StoreFileInfo> newFiles) throws IOException {
        Map<String, StoreFileInfo> map = this.storefiles;
        synchronized (map) {
            StoreFileTrackerProtos.StoreFileList.Builder builder = StoreFileTrackerProtos.StoreFileList.newBuilder();
            for (StoreFileInfo info : this.storefiles.values()) {
                builder.addStoreFile(this.toStoreFileEntry(info));
            }
            for (StoreFileInfo info : newFiles) {
                builder.addStoreFile(this.toStoreFileEntry(info));
            }
            this.backedFile.update(builder);
            if (LOG.isTraceEnabled()) {
                LOG.trace(newFiles.size() + " store files added to store file list file: " + newFiles);
            }
            for (StoreFileInfo info : newFiles) {
                this.storefiles.put(info.getPath().getName(), info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAddCompactionResults(Collection<StoreFileInfo> compactedFiles, Collection<StoreFileInfo> newFiles) throws IOException {
        Set compactedFileNames = compactedFiles.stream().map(info -> info.getPath().getName()).collect(Collectors.toSet());
        Map<String, StoreFileInfo> map = this.storefiles;
        synchronized (map) {
            StoreFileTrackerProtos.StoreFileList.Builder builder = StoreFileTrackerProtos.StoreFileList.newBuilder();
            this.storefiles.forEach((name, info) -> {
                if (compactedFileNames.contains(name)) {
                    return;
                }
                builder.addStoreFile(this.toStoreFileEntry((StoreFileInfo)info));
            });
            for (StoreFileInfo info2 : newFiles) {
                builder.addStoreFile(this.toStoreFileEntry(info2));
            }
            this.backedFile.update(builder);
            if (LOG.isTraceEnabled()) {
                LOG.trace("replace compacted files: " + compactedFileNames + " with new store files: " + newFiles);
            }
            for (String name2 : compactedFileNames) {
                this.storefiles.remove(name2);
            }
            for (StoreFileInfo info2 : newFiles) {
                this.storefiles.put(info2.getPath().getName(), info2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetStoreFiles(Collection<StoreFileInfo> files) throws IOException {
        Map<String, StoreFileInfo> map = this.storefiles;
        synchronized (map) {
            this.storefiles.clear();
            StoreFileTrackerProtos.StoreFileList.Builder builder = StoreFileTrackerProtos.StoreFileList.newBuilder();
            for (StoreFileInfo info : files) {
                this.storefiles.put(info.getPath().getName(), info);
                builder.addStoreFile(this.toStoreFileEntry(info));
            }
            this.backedFile.update(builder);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set store files in store file list file: " + files);
            }
        }
    }
}

