/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MobFileCleanupUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MobFileCleanupUtil.class);

    private MobFileCleanupUtil() {
    }

    /*
     * Exception decompiling
     */
    public static void cleanupObsoleteMobFiles(Configuration conf, TableName table, Admin admin) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkColumnFamilyDescriptor(Configuration conf, TableName table, FileSystem fs, Admin admin, ColumnFamilyDescriptor hcd, Set<String> regionNames, long maxCreationTimeToArchive) throws IOException {
        ArrayList<Path> toArchive = new ArrayList<Path>();
        String family = hcd.getNameAsString();
        Path dir = MobUtils.getMobFamilyPath(conf, table, family);
        RemoteIterator rit = fs.listLocatedStatus(dir);
        while (rit.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)rit.next();
            Path p = lfs.getPath();
            String[] mobParts = p.getName().split("_");
            String regionName = mobParts[mobParts.length - 1];
            if (!regionNames.contains(regionName)) {
                long creationTime = fs.getFileStatus(p).getModificationTime();
                if (creationTime < maxCreationTimeToArchive) {
                    LOG.trace("Archiving MOB file {} creation time={}", (Object)p, (Object)fs.getFileStatus(p).getModificationTime());
                    toArchive.add(p);
                    continue;
                }
                LOG.trace("Skipping fresh file: {}. Creation time={}", (Object)p, (Object)fs.getFileStatus(p).getModificationTime());
                continue;
            }
            LOG.trace("Keeping MOB file with existing region: {}", (Object)p);
        }
        LOG.info(" MOB Cleaner found {} files to archive for table={} family={}", new Object[]{toArchive.size(), table, family});
        MobFileCleanupUtil.archiveMobFiles(conf, table, admin, family.getBytes(), toArchive);
        LOG.info(" MOB Cleaner archived {} files, table={} family={}", new Object[]{toArchive.size(), table, family});
    }

    private static void archiveMobFiles(Configuration conf, TableName tableName, Admin admin, byte[] family, List<Path> storeFiles) throws IOException {
        if (storeFiles.size() == 0) {
            LOG.debug("Skipping archiving old MOB files - no files found for table={} cf={}", (Object)tableName, (Object)Bytes.toString((byte[])family));
            return;
        }
        Path mobTableDir = CommonFSUtils.getTableDir((Path)MobUtils.getMobHome(conf), (TableName)tableName);
        FileSystem fs = storeFiles.get(0).getFileSystem(conf);
        for (Path p : storeFiles) {
            LOG.debug("MOB Cleaner is archiving: {}", (Object)p);
            HFileArchiver.archiveStoreFile(conf, fs, MobUtils.getMobRegionInfo(tableName), mobTableDir, family, p);
        }
    }
}

