/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.Queue;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.LockStatus;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class TableQueue
extends Queue<TableName> {
    private final LockStatus namespaceLockStatus;

    public TableQueue(TableName tableName, int priority, LockStatus tableLock, LockStatus namespaceLockStatus) {
        super(tableName, priority, tableLock);
        this.namespaceLockStatus = namespaceLockStatus;
    }

    @Override
    public boolean isAvailable() {
        return !this.isEmpty() && !this.namespaceLockStatus.hasExclusiveLock();
    }

    @Override
    public boolean requireExclusiveLock(Procedure<?> proc) {
        return TableQueue.requireTableExclusiveLock((TableProcedureInterface)proc);
    }

    static boolean requireTableExclusiveLock(TableProcedureInterface proc) {
        switch (proc.getTableOperationType()) {
            case CREATE: 
            case DELETE: 
            case DISABLE: 
            case SNAPSHOT: 
            case ENABLE: {
                return true;
            }
            case EDIT: {
                return !proc.getTableName().equals((Object)TableName.NAMESPACE_TABLE_NAME);
            }
            case READ: 
            case FLUSH: {
                return false;
            }
            case REGION_SPLIT: 
            case REGION_MERGE: 
            case REGION_ASSIGN: 
            case REGION_UNASSIGN: 
            case REGION_EDIT: 
            case REGION_GC: 
            case MERGED_REGIONS_GC: 
            case REGION_SNAPSHOT: 
            case REGION_TRUNCATE: {
                return false;
            }
        }
        throw new UnsupportedOperationException("unexpected type " + (Object)((Object)proc.getTableOperationType()));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("namespaceLockStatus", (Object)this.namespaceLockStatus.describeLockStatus()).build();
    }
}

