/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.HandlerUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@InterfaceAudience.Private
public class AssignRegionHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AssignRegionHandler.class);
    private final RegionInfo regionInfo;
    private final long openProcId;
    private final TableDescriptor tableDesc;
    private final long masterSystemTime;
    private final long initiatingMasterActiveTime;
    private final RetryCounter retryCounter;

    public AssignRegionHandler(HRegionServer server, RegionInfo regionInfo, long openProcId, @Nullable TableDescriptor tableDesc, long masterSystemTime, long initiatingMasterActiveTime, EventType eventType) {
        super(server, eventType);
        this.regionInfo = regionInfo;
        this.openProcId = openProcId;
        this.tableDesc = tableDesc;
        this.masterSystemTime = masterSystemTime;
        this.initiatingMasterActiveTime = initiatingMasterActiveTime;
        this.retryCounter = HandlerUtil.getRetryCounter();
    }

    private HRegionServer getServer() {
        return (HRegionServer)this.server;
    }

    private void cleanUpAndReportFailure(IOException error) throws IOException {
        LOG.warn("Failed to open region {}, will report to master", (Object)this.regionInfo.getRegionNameAsString(), (Object)error);
        HRegionServer rs = this.getServer();
        rs.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes(), Boolean.TRUE);
        if (!rs.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN, -1L, this.openProcId, this.masterSystemTime, this.regionInfo, this.initiatingMasterActiveTime))) {
            throw new IOException("Failed to report failed open to master: " + this.regionInfo.getRegionNameAsString());
        }
    }

    @Override
    public void process() throws IOException {
        HRegion region;
        MDC.put((String)"pid", (String)Long.toString(this.openProcId));
        HRegionServer rs = this.getServer();
        String encodedName = this.regionInfo.getEncodedName();
        byte[] encodedNameBytes = this.regionInfo.getEncodedNameAsBytes();
        String regionName = this.regionInfo.getRegionNameAsString();
        HRegion onlineRegion = rs.getRegion(encodedName);
        if (onlineRegion != null) {
            LOG.warn("Received OPEN for {} which is already online", (Object)regionName);
            return;
        }
        Boolean previous = rs.getRegionsInTransitionInRS().putIfAbsent(encodedNameBytes, Boolean.TRUE);
        if (previous != null) {
            if (previous.booleanValue()) {
                LOG.info("Receiving OPEN for {} which we are already trying to OPEN - ignoring this new request for this region.", (Object)regionName);
            } else {
                long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
                LOG.info("Receiving OPEN for {} which we are trying to close, try again after {}ms", (Object)regionName, (Object)backoff);
                rs.getExecutorService().delayedSubmit(this, backoff, TimeUnit.MILLISECONDS);
            }
            return;
        }
        LOG.info("Open {}", (Object)regionName);
        try {
            TableName tn;
            TableDescriptor htd;
            TableDescriptor tableDescriptor = htd = this.tableDesc != null ? this.tableDesc : rs.getTableDescriptors().get(this.regionInfo.getTable());
            if (htd == null) {
                throw new IOException("Missing table descriptor for " + regionName);
            }
            Configuration conf = rs.getConfiguration();
            if (ServerRegionReplicaUtil.isMetaRegionReplicaReplicationEnabled(conf, tn = htd.getTableName()) && RegionReplicaUtil.isDefaultReplica((int)this.regionInfo.getReplicaId())) {
                rs.getReplicationSourceService().getReplicationManager().addCatalogReplicationSource(this.regionInfo);
            }
            region = HRegion.openHRegion(this.regionInfo, htd, rs.getWAL(this.regionInfo), conf, rs, null);
        }
        catch (IOException e) {
            this.cleanUpAndReportFailure(e);
            return;
        }
        rs.postOpenDeployTasks(new RegionServerServices.PostOpenDeployContext(region, this.openProcId, this.masterSystemTime, this.initiatingMasterActiveTime));
        rs.addRegion(region);
        LOG.info("Opened {}", (Object)regionName);
        rs.finishRegionProcedure(this.openProcId);
        Boolean current = (Boolean)rs.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        if (current == null) {
            LOG.error("Bad state: we've just opened {} which was NOT in transition", (Object)regionName);
        } else if (!current.booleanValue()) {
            LOG.error("Bad state: we've just opened {} which was closing", (Object)regionName);
        }
    }

    @Override
    protected void handleException(Throwable t) {
        LOG.warn("Fatal error occurred while opening region {}, aborting...", (Object)this.regionInfo.getRegionNameAsString(), (Object)t);
        this.getServer().getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        this.getServer().abort("Failed to open region " + this.regionInfo.getRegionNameAsString() + " and can not recover", t);
    }

    public static AssignRegionHandler create(HRegionServer server, RegionInfo regionInfo, long openProcId, TableDescriptor tableDesc, long masterSystemTime, long initiatingMasterActiveTime) {
        EventType eventType = regionInfo.isMetaRegion() ? EventType.M_RS_OPEN_META : (regionInfo.getTable().isSystemTable() || tableDesc != null && tableDesc.getPriority() >= 100 ? EventType.M_RS_OPEN_PRIORITY_REGION : EventType.M_RS_OPEN_REGION);
        return new AssignRegionHandler(server, regionInfo, openProcId, tableDesc, masterSystemTime, initiatingMasterActiveTime, eventType);
    }
}

