/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableCollection;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DefaultStoreFileManager
implements StoreFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStoreFileManager.class);
    private final CellComparator cellComparator;
    private final CompactionConfiguration comConf;
    private final int blockingFileCount;
    private final Comparator<HStoreFile> storeFileComparator;
    private volatile StoreFileList storeFiles;
    private volatile ImmutableList<HStoreFile> compactedfiles = ImmutableList.of();
    private final boolean enableLiveFileTracking;

    public DefaultStoreFileManager(CellComparator cellComparator, Comparator<HStoreFile> storeFileComparator, Configuration conf, CompactionConfiguration comConf) {
        this.cellComparator = cellComparator;
        this.storeFileComparator = storeFileComparator;
        this.comConf = comConf;
        this.blockingFileCount = conf.getInt(HStore.BLOCKING_STOREFILES_KEY, 16);
        this.enableLiveFileTracking = StoreFileWriter.shouldEnableHistoricalCompactionFiles(conf);
        this.storeFiles = new StoreFileList((ImmutableList<HStoreFile>)ImmutableList.of(), (ImmutableList<HStoreFile>)(this.enableLiveFileTracking ? ImmutableList.of() : null));
    }

    private List<HStoreFile> getLiveFiles(Collection<HStoreFile> storeFiles) throws IOException {
        ArrayList<HStoreFile> liveFiles = new ArrayList<HStoreFile>(storeFiles.size());
        for (HStoreFile file : storeFiles) {
            file.initReader();
            if (file.isHistorical()) continue;
            liveFiles.add(file);
        }
        return liveFiles;
    }

    @Override
    public void loadFiles(List<HStoreFile> storeFiles) throws IOException {
        this.storeFiles = new StoreFileList((ImmutableList<HStoreFile>)ImmutableList.sortedCopyOf(this.storeFileComparator, storeFiles), this.enableLiveFileTracking ? ImmutableList.sortedCopyOf(this.storeFileComparator, this.getLiveFiles(storeFiles)) : null);
    }

    @Override
    public final Collection<HStoreFile> getStoreFiles() {
        return this.storeFiles.all;
    }

    @Override
    public Collection<HStoreFile> getCompactedfiles() {
        return this.compactedfiles;
    }

    @Override
    public void insertNewFiles(Collection<HStoreFile> sfs) throws IOException {
        this.storeFiles = new StoreFileList((ImmutableList<HStoreFile>)ImmutableList.sortedCopyOf(this.storeFileComparator, (Iterable)Iterables.concat(this.storeFiles.all, sfs)), this.enableLiveFileTracking ? ImmutableList.sortedCopyOf(this.storeFileComparator, (Iterable)Iterables.concat(this.storeFiles.live, this.getLiveFiles(sfs))) : null);
    }

    @Override
    public ImmutableCollection<HStoreFile> clearFiles() {
        ImmutableList<HStoreFile> result = this.storeFiles.all;
        this.storeFiles = new StoreFileList((ImmutableList<HStoreFile>)ImmutableList.of(), (ImmutableList<HStoreFile>)(this.enableLiveFileTracking ? ImmutableList.of() : null));
        return result;
    }

    @Override
    public Collection<HStoreFile> clearCompactedFiles() {
        ImmutableList<HStoreFile> result = this.compactedfiles;
        this.compactedfiles = ImmutableList.of();
        return result;
    }

    @Override
    public final int getStorefileCount() {
        return this.storeFiles.all.size();
    }

    @Override
    public final int getCompactedFilesCount() {
        return this.compactedfiles.size();
    }

    @Override
    public void addCompactionResults(Collection<HStoreFile> newCompactedfiles, Collection<HStoreFile> results) throws IOException {
        ImmutableList liveStoreFiles = null;
        if (this.enableLiveFileTracking) {
            liveStoreFiles = ImmutableList.sortedCopyOf(this.storeFileComparator, (Iterable)Iterables.concat((Iterable)Iterables.filter(this.storeFiles.live, sf -> !newCompactedfiles.contains(sf)), this.getLiveFiles(results)));
        }
        this.storeFiles = new StoreFileList((ImmutableList<HStoreFile>)ImmutableList.sortedCopyOf(this.storeFileComparator, (Iterable)Iterables.concat((Iterable)Iterables.filter(this.storeFiles.all, sf -> !newCompactedfiles.contains(sf)), results)), (ImmutableList<HStoreFile>)liveStoreFiles);
        newCompactedfiles.forEach(HStoreFile::markCompactedAway);
        this.compactedfiles = ImmutableList.sortedCopyOf(this.storeFileComparator, (Iterable)Iterables.concat(this.compactedfiles, newCompactedfiles));
    }

    @Override
    public void removeCompactedFiles(Collection<HStoreFile> removedCompactedfiles) {
        this.compactedfiles = (ImmutableList)this.compactedfiles.stream().filter(sf -> !removedCompactedfiles.contains(sf)).sorted(this.storeFileComparator).collect(ImmutableList.toImmutableList());
    }

    @Override
    public final Iterator<HStoreFile> getCandidateFilesForRowKeyBefore(KeyValue targetKey) {
        return this.storeFiles.all.reverse().iterator();
    }

    @Override
    public Iterator<HStoreFile> updateCandidateFilesForRowKeyBefore(Iterator<HStoreFile> candidateFiles, KeyValue targetKey, Cell candidate) {
        return candidateFiles;
    }

    @Override
    public final Optional<byte[]> getSplitPoint() throws IOException {
        return StoreUtils.getSplitPoint(this.storeFiles.all, this.cellComparator);
    }

    @Override
    public Collection<HStoreFile> getFilesForScan(byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, boolean onlyLatestVersion) {
        if (onlyLatestVersion && this.enableLiveFileTracking) {
            return this.storeFiles.live;
        }
        return this.getStoreFiles();
    }

    @Override
    public int getStoreCompactionPriority() {
        int priority = this.blockingFileCount - this.storeFiles.all.size();
        return priority == 1 ? priority + 1 : priority;
    }

    @Override
    public Collection<HStoreFile> getUnneededFiles(long maxTs, List<HStoreFile> filesCompacting) {
        ImmutableList<HStoreFile> files = this.storeFiles.all;
        return files.stream().limit(Math.max(0, files.size() - 1)).filter(sf -> {
            long fileTs = sf.getReader().getMaxTimestamp();
            if (fileTs < maxTs && !filesCompacting.contains(sf)) {
                LOG.info("Found an expired store file {} whose maxTimestamp is {}, which is below {}", new Object[]{sf.getPath(), fileTs, maxTs});
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    @Override
    public double getCompactionPressure() {
        int minFilesToCompact;
        int storefileCount = this.getStorefileCount();
        if (storefileCount <= (minFilesToCompact = this.comConf.getMinFilesToCompact())) {
            return 0.0;
        }
        return (double)(storefileCount - minFilesToCompact) / (double)(this.blockingFileCount - minFilesToCompact);
    }

    @Override
    public Comparator<HStoreFile> getStoreFileComparator() {
        return this.storeFileComparator;
    }

    static class StoreFileList {
        final ImmutableList<HStoreFile> all;
        @Nullable
        final ImmutableList<HStoreFile> live;

        StoreFileList(ImmutableList<HStoreFile> storeFiles, ImmutableList<HStoreFile> liveStoreFiles) {
            this.all = storeFiles;
            this.live = liveStoreFiles;
        }
    }
}

