/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExploringCompactionPolicy
extends RatioBasedCompactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ExploringCompactionPolicy.class);

    public ExploringCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    @Override
    protected final ArrayList<HStoreFile> applyCompactionPolicy(ArrayList<HStoreFile> candidates, boolean mayUseOffPeak, boolean mightBeStuck) throws IOException {
        return new ArrayList<HStoreFile>(this.applyCompactionPolicy(candidates, mightBeStuck, mayUseOffPeak, this.comConf.getMinFilesToCompact(), this.comConf.getMaxFilesToCompact()));
    }

    public List<HStoreFile> applyCompactionPolicy(List<HStoreFile> candidates, boolean mightBeStuck, boolean mayUseOffPeak, int minFiles, int maxFiles) {
        double currentRatio = mayUseOffPeak ? this.comConf.getCompactionRatioOffPeak() : this.comConf.getCompactionRatio();
        List<HStoreFile> bestSelection = new ArrayList<HStoreFile>(0);
        List<Object> smallest = mightBeStuck ? new ArrayList(0) : null;
        long bestSize = 0L;
        long smallestSize = Long.MAX_VALUE;
        int opts = 0;
        int optsInRatio = 0;
        int bestStart = -1;
        for (int start = 0; start < candidates.size(); ++start) {
            for (int currentEnd = start + minFiles - 1; currentEnd < candidates.size(); ++currentEnd) {
                List<HStoreFile> potentialMatchFiles = candidates.subList(start, currentEnd + 1);
                if (potentialMatchFiles.size() < minFiles || potentialMatchFiles.size() > maxFiles) continue;
                long size = this.getTotalStoreSize(potentialMatchFiles);
                if (mightBeStuck && size < smallestSize) {
                    smallest = potentialMatchFiles;
                    smallestSize = size;
                }
                if (size > this.comConf.getMaxCompactSize(mayUseOffPeak)) continue;
                ++opts;
                if (size >= this.comConf.getMinCompactSize() && !this.filesInRatio(potentialMatchFiles, currentRatio)) continue;
                ++optsInRatio;
                if (!this.isBetterSelection(bestSelection, bestSize, potentialMatchFiles, size, mightBeStuck)) continue;
                bestSelection = potentialMatchFiles;
                bestSize = size;
                bestStart = start;
            }
        }
        if (bestSelection.isEmpty() && mightBeStuck) {
            LOG.debug("Exploring compaction algorithm has selected " + smallest.size() + " files of size " + smallestSize + " because the store might be stuck");
            return new ArrayList<HStoreFile>(smallest);
        }
        LOG.debug("Exploring compaction algorithm has selected {}  files of size {} starting at candidate #{} after considering {} permutations with {} in ratio", new Object[]{bestSelection.size(), bestSize, bestStart, opts, optsInRatio});
        return new ArrayList<HStoreFile>(bestSelection);
    }

    public List<HStoreFile> selectCompactFiles(List<HStoreFile> candidates, int maxFiles, boolean isOffpeak) {
        long selectedSize = 0L;
        for (int end = 0; end < Math.min(candidates.size(), maxFiles); ++end) {
            if ((selectedSize += candidates.get(end).getReader().length()) < this.comConf.getMaxCompactSize(isOffpeak)) continue;
            return candidates.subList(0, end + 1);
        }
        return candidates;
    }

    private boolean isBetterSelection(List<HStoreFile> bestSelection, long bestSize, List<HStoreFile> selection, long size, boolean mightBeStuck) {
        if (mightBeStuck && bestSize > 0L && size > 0L) {
            double REPLACE_IF_BETTER_BY = 1.05;
            double thresholdQuality = (double)bestSelection.size() / (double)bestSize * 1.05;
            return thresholdQuality < (double)selection.size() / (double)size;
        }
        return selection.size() > bestSelection.size() || selection.size() == bestSelection.size() && size < bestSize;
    }

    private long getTotalStoreSize(List<HStoreFile> potentialMatchFiles) {
        return potentialMatchFiles.stream().mapToLong(sf -> sf.getReader().length()).sum();
    }

    private boolean filesInRatio(List<HStoreFile> files, double currentRatio) {
        if (files.size() < 2) {
            return true;
        }
        long totalFileSize = this.getTotalStoreSize(files);
        for (HStoreFile file : files) {
            long sumAllOtherFileSizes;
            long singleFileSize = file.getReader().length();
            if (!((double)singleFileSize > (double)(sumAllOtherFileSizes = totalFileSize - singleFileSize) * currentRatio)) continue;
            return false;
        }
        return true;
    }
}

