/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class StoreFlusher {
    protected Configuration conf;
    protected HStore store;

    public StoreFlusher(Configuration conf, HStore store) {
        this.conf = conf;
        this.store = store;
    }

    public abstract List<Path> flushSnapshot(MemStoreSnapshot var1, long var2, MonitoredTask var4, ThroughputController var5, FlushLifeCycleTracker var6, Consumer<Path> var7) throws IOException;

    protected void finalizeWriter(StoreFileWriter writer, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        status.setStatus("Flushing " + this.store + ": appending metadata");
        writer.appendMetadata(cacheFlushSeqNum, false);
        status.setStatus("Flushing " + this.store + ": closing flushed file");
        writer.close();
    }

    protected final StoreFileWriter createWriter(MemStoreSnapshot snapshot, boolean alwaysIncludesTag, Consumer<Path> writerCreationTracker) throws IOException {
        return this.store.getStoreEngine().createWriter(CreateStoreFileWriterParams.create().maxKeyCount(snapshot.getCellsCount()).compression(this.store.getColumnFamilyDescriptor().getCompressionType()).isCompaction(false).includeMVCCReadpoint(true).includesTag(alwaysIncludesTag || snapshot.isTagsPresent()).shouldDropBehind(false).writerCreationTracker(writerCreationTracker));
    }

    protected final InternalScanner createScanner(List<KeyValueScanner> snapshotScanners, FlushLifeCycleTracker tracker) throws IOException {
        ScanInfo scanInfo = this.store.getCoprocessorHost() != null ? this.store.getCoprocessorHost().preFlushScannerOpen(this.store, tracker) : this.store.getScanInfo();
        long smallestReadPoint = this.store.getSmallestReadPoint();
        StoreScanner scanner = new StoreScanner(this.store, scanInfo, snapshotScanners, ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, Long.MIN_VALUE);
        if (this.store.getCoprocessorHost() != null) {
            try {
                return this.store.getCoprocessorHost().preFlush(this.store, scanner, tracker);
            }
            catch (IOException ioe) {
                scanner.close();
                throw ioe;
            }
        }
        return scanner;
    }

    protected void performFlush(InternalScanner scanner, CellSink sink, ThroughputController throughputController) throws IOException {
        boolean control;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(compactionKVMax).build();
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        String flushName = ThroughputControlUtil.getNameForThrottling(this.store, "flush");
        boolean bl = control = throughputController != null && !this.store.getRegionInfo().getTable().isSystemTable();
        if (control) {
            throughputController.start(flushName);
        }
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(kvs, scannerContext);
                if (kvs.isEmpty()) continue;
                for (Cell c : kvs) {
                    sink.append(c);
                    if (!control) continue;
                    throughputController.control(flushName, c.getSerializedSize());
                }
                kvs.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while control throughput of flushing " + flushName);
        }
        finally {
            if (control) {
                throughputController.finish(flushName);
            }
        }
    }
}

