/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import org.apache.hadoop.hbase.CallDroppedException;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class CallRunner {
    private static final CallDroppedException CALL_DROPPED_EXCEPTION = new CallDroppedException();
    private RpcCall call;
    private RpcServerInterface rpcServer;
    private MonitoredRPCHandler status;
    private final Span span;
    private volatile boolean successful;

    CallRunner(RpcServerInterface rpcServer, RpcCall call) {
        this.call = call;
        this.rpcServer = rpcServer;
        this.span = Span.current();
        if (call != null && rpcServer != null) {
            this.rpcServer.addCallSize(call.getSize());
        }
    }

    public RpcCall getRpcCall() {
        return this.call;
    }

    public void setStatus(MonitoredRPCHandler status) {
        this.status = status;
    }

    private void cleanup() {
        this.call.cleanup();
        this.call = null;
        this.rpcServer = null;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 65[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() {
        try (Scope ignored = this.span.makeCurrent();){
            if (this.call.disconnectSince() >= 0L) {
                RpcServer.LOG.debug("{}: skipped {}", (Object)Thread.currentThread().getName(), (Object)this.call);
                this.span.addEvent("Client disconnect detected");
                this.span.setStatus(StatusCode.OK);
                return;
            }
            InetSocketAddress address = this.rpcServer.getListenerAddress();
            this.call.setResponse(null, null, (Throwable)CALL_DROPPED_EXCEPTION, "Call dropped, server " + (address != null ? address : "(channel closed)") + " is overloaded, please retry.");
            TraceUtil.setError((Span)this.span, (Throwable)CALL_DROPPED_EXCEPTION);
            this.call.sendResponseIfReady();
            this.rpcServer.getMetrics().exception((Throwable)CALL_DROPPED_EXCEPTION);
        }
        catch (ClosedChannelException cce) {
            InetSocketAddress address = this.rpcServer.getListenerAddress();
            RpcServer.LOG.warn("{}: caught a ClosedChannelException, this means that the server " + (address != null ? address : "(channel closed)") + " was processing a request but the client went away. The error message was: {}", (Object)Thread.currentThread().getName(), (Object)cce.getMessage());
            TraceUtil.setError((Span)this.span, (Throwable)cce);
        }
        catch (Exception e) {
            RpcServer.LOG.warn("{}: caught: {}", (Object)Thread.currentThread().getName(), (Object)StringUtils.stringifyException((Throwable)e));
            TraceUtil.setError((Span)this.span, (Throwable)e);
        }
        finally {
            if (!this.successful) {
                this.rpcServer.addCallSize(this.call.getSize() * -1L);
            }
            this.cleanup();
            this.span.end();
        }
    }
}

