/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.ProfileOutputServlet;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProfileOutputServlet {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProfileOutputServlet.class);

    @Test
    public void testSanitization() {
        List<String> good = Arrays.asList("abcd", "key=value", "key1=value&key2=value2", "", "host=host-1.example.com");
        for (String input : good) {
            Assert.assertEquals((Object)input, (Object)ProfileOutputServlet.sanitize((String)input));
        }
        List<String> bad = Arrays.asList("function(){console.log(\"oops\")}", "<strong>uhoh</strong>");
        for (String input : bad) {
            try {
                ProfileOutputServlet.sanitize((String)input);
                Assert.fail((String)("Expected sanitization of \"" + input + "\" to fail"));
            }
            catch (RuntimeException runtimeException) {}
        }
    }
}

