/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.FilterContainer;
import org.apache.hadoop.hbase.http.FilterInitializer;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestServletFilter
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServletFilter.class);
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private static volatile String uri = null;

    private static void assertExceptionContains(String string, Throwable t) {
        String msg = t.getMessage();
        Assert.assertTrue((String)("Expected to find '" + string + "' but got unexpected exception:" + StringUtils.stringifyException((Throwable)t)), (boolean)msg.contains(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testServletFilter() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.http.filter.initializers", SimpleFilter.Initializer.class.getName());
        HttpServer http = TestServletFilter.createTestServer(conf);
        http.start();
        String fsckURL = "/fsck";
        String stacksURL = "/stacks";
        String ajspURL = "/a.jsp";
        String logURL = "/logs/a.log";
        String hadooplogoURL = "/static/hadoop-logo.jpg";
        String[] urls = new String[]{"/fsck", "/stacks", "/a.jsp", "/logs/a.log", "/static/hadoop-logo.jpg"};
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int[] sequence = new int[50];
        for (int i = 0; i < sequence.length; ++i) {
            sequence[i] = ((Random)rand).nextInt(urls.length);
        }
        String prefix = "http://" + NetUtils.getHostPortString((InetSocketAddress)http.getConnectorAddress(0));
        try {
            for (int aSequence : sequence) {
                TestServletFilter.access(prefix + urls[aSequence]);
                if (aSequence == 0) {
                    TestServletFilter.assertNull((Object)uri);
                    continue;
                }
                TestServletFilter.assertEquals((Object)urls[aSequence], (Object)uri);
                uri = null;
            }
        }
        finally {
            http.stop();
        }
    }

    @Test
    public void testServletFilterWhenInitThrowsException() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.http.filter.initializers", ErrorFilter.Initializer.class.getName());
        HttpServer http = TestServletFilter.createTestServer(conf);
        try {
            http.start();
            TestServletFilter.fail((String)"expecting exception");
        }
        catch (IOException e) {
            TestServletFilter.assertExceptionContains("Problem starting http server", e);
        }
    }

    @Test
    public void testContextSpecificServletFilterWhenInitThrowsException() throws Exception {
        Configuration conf = new Configuration();
        HttpServer http = TestServletFilter.createTestServer(conf);
        HttpServer.defineFilter((ServletContextHandler)http.webAppContext, (String)"ErrorFilter", (String)ErrorFilter.class.getName(), null, null);
        try {
            http.start();
            TestServletFilter.fail((String)"expecting exception");
        }
        catch (IOException e) {
            TestServletFilter.assertExceptionContains("Unable to initialize WebAppContext", e);
        }
    }

    public static class ErrorFilter
    extends SimpleFilter {
        @Override
        public void init(FilterConfig arg0) throws ServletException {
            throw new ServletException("Throwing the exception from Filter init");
        }

        public static class Initializer
        extends FilterInitializer {
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addFilter("simple", ErrorFilter.class.getName(), null);
            }
        }
    }

    public static class SimpleFilter
    implements Filter {
        private FilterConfig filterConfig = null;

        public void init(FilterConfig filterConfig) throws ServletException {
            this.filterConfig = filterConfig;
        }

        public void destroy() {
            this.filterConfig = null;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.filterConfig == null) {
                return;
            }
            uri = ((HttpServletRequest)request).getRequestURI();
            LOG.info("filtering " + uri);
            chain.doFilter(request, response);
        }

        public static class Initializer
        extends FilterInitializer {
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addFilter("simple", SimpleFilter.class.getName(), null);
            }
        }
    }
}

