/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.http.TestHttpServer;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestSSLHttpServer
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSSLHttpServer.class);
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestSSLHttpServer.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(TestSSLHttpServer.class);
    private static Configuration serverConf;
    private static HttpServer server;
    private static URL baseUrl;
    private static File keystoresDir;
    private static String sslConfDir;
    private static SSLFactory clientSslFactory;
    private static HBaseCommonTestingUtility HTU;

    @BeforeClass
    public static void setup() throws Exception {
        HTU = new HBaseCommonTestingUtility();
        serverConf = HTU.getConfiguration();
        serverConf.setInt("hbase.http.max.threads", 16);
        keystoresDir = new File(HTU.getDataTestDir("keystore").toString());
        keystoresDir.mkdirs();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir.getAbsolutePath(), sslConfDir, serverConf, false);
        Configuration clientConf = new Configuration(false);
        clientConf.addResource(serverConf.get("hadoop.ssl.client.conf"));
        serverConf.addResource(serverConf.get("hadoop.ssl.server.conf"));
        clientConf.set("hadoop.ssl.client.conf", serverConf.get("hadoop.ssl.client.conf"));
        clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, clientConf);
        clientSslFactory.init();
        server = new HttpServer.Builder().setName("test").addEndpoint(new URI("https://localhost")).setConf(serverConf).keyPassword(HBaseConfiguration.getPassword((Configuration)serverConf, (String)"ssl.server.keystore.keypassword", null)).keyStore(serverConf.get("ssl.server.keystore.location"), HBaseConfiguration.getPassword((Configuration)serverConf, (String)"ssl.server.keystore.password", null), clientConf.get("ssl.server.keystore.type", "jks")).trustStore(serverConf.get("ssl.server.truststore.location"), HBaseConfiguration.getPassword((Configuration)serverConf, (String)"ssl.server.truststore.password", null), serverConf.get("ssl.server.truststore.type", "jks")).build();
        server.addUnprivilegedServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.start();
        baseUrl = new URL("https://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
        FileUtil.fullyDelete((File)new File(HTU.getDataTestDir().toString()));
        KeyStoreTestUtil.cleanupSSLConfig(serverConf);
        clientSslFactory.destroy();
    }

    @Test
    public void testEcho() throws Exception {
        TestSSLHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c=d")));
        TestSSLHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    private static String readOut(URL url) throws Exception {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(clientSslFactory.createSSLSocketFactory());
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        return out.toString();
    }
}

