/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.http.TestHttpServer;
import org.apache.hadoop.hbase.http.resource.JerseyResource;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.JaasKrbUtil;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestSpnegoHttpServer
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpnegoHttpServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpnegoHttpServer.class);
    private static final String KDC_SERVER_HOST = "localhost";
    private static final String CLIENT_PRINCIPAL = "client";
    private static HttpServer server;
    private static URL baseUrl;
    private static SimpleKdcServer kdc;
    private static File infoServerKeytab;
    private static File clientKeytab;

    @BeforeClass
    public static void setupServer() throws Exception {
        String serverPrincipal = "HTTP/localhost";
        File target = new File(System.getProperty("user.dir"), "target");
        TestSpnegoHttpServer.assertTrue((boolean)target.exists());
        kdc = TestSpnegoHttpServer.buildMiniKdc();
        kdc.start();
        File keytabDir = new File(target, TestSpnegoHttpServer.class.getSimpleName() + "_keytabs");
        if (keytabDir.exists()) {
            TestSpnegoHttpServer.deleteRecursively(keytabDir);
        }
        keytabDir.mkdirs();
        infoServerKeytab = new File(keytabDir, "HTTP/localhost".replace('/', '_') + ".keytab");
        clientKeytab = new File(keytabDir, "client.keytab");
        TestSpnegoHttpServer.setupUser(kdc, clientKeytab, CLIENT_PRINCIPAL);
        TestSpnegoHttpServer.setupUser(kdc, infoServerKeytab, "HTTP/localhost");
        Configuration conf = TestSpnegoHttpServer.buildSpnegoConfiguration("HTTP/localhost", infoServerKeytab);
        server = TestSpnegoHttpServer.createTestServerWithSecurity(conf);
        server.addServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = TestSpnegoHttpServer.getServerURL(server);
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterClass
    public static void stopServer() throws Exception {
        try {
            if (null != server) {
                server.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop info server", (Throwable)e);
        }
        try {
            if (null != kdc) {
                kdc.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop mini KDC", (Throwable)e);
        }
    }

    private static void setupUser(SimpleKdcServer kdc, File keytab, String principal) throws KrbException {
        kdc.createPrincipal(principal);
        kdc.exportPrincipal(principal, keytab);
    }

    private static SimpleKdcServer buildMiniKdc() throws Exception {
        SimpleKdcServer kdc = new SimpleKdcServer();
        File target = new File(System.getProperty("user.dir"), "target");
        File kdcDir = new File(target, TestSpnegoHttpServer.class.getSimpleName());
        if (kdcDir.exists()) {
            TestSpnegoHttpServer.deleteRecursively(kdcDir);
        }
        kdcDir.mkdirs();
        kdc.setWorkDir(kdcDir);
        kdc.setKdcHost(KDC_SERVER_HOST);
        int kdcPort = TestSpnegoHttpServer.getFreePort();
        kdc.setAllowTcp(true);
        kdc.setAllowUdp(false);
        kdc.setKdcTcpPort(kdcPort);
        LOG.info("Starting KDC server at localhost:" + kdcPort);
        kdc.init();
        return kdc;
    }

    private static Configuration buildSpnegoConfiguration(String serverPrincipal, File serverKeytab) {
        Configuration conf = new Configuration();
        KerberosName.setRules((String)"DEFAULT");
        conf.setInt("hbase.http.max.threads", 16);
        conf.set("hbase.security.authentication", "kerberos");
        conf.set("hbase.security.authentication.ui", "kerberos");
        conf.set("hbase.security.authentication.spnego.kerberos.principal", serverPrincipal);
        conf.set("hbase.security.authentication.spnego.kerberos.keytab", serverKeytab.getAbsolutePath());
        return conf;
    }

    @Test
    public void testUnauthorizedClientsDisallowed() throws IOException {
        URL url = new URL(TestSpnegoHttpServer.getServerURL(server), "/echo?a=b");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestSpnegoHttpServer.assertEquals((long)401L, (long)conn.getResponseCode());
    }

    @Test
    public void testAllowedClient() throws Exception {
        Subject clientSubject = JaasKrbUtil.loginUsingKeytab((String)CLIENT_PRINCIPAL, (File)clientKeytab);
        Set<Principal> clientPrincipals = clientSubject.getPrincipals();
        TestSpnegoHttpServer.assertFalse((boolean)clientPrincipals.isEmpty());
        Set<KerberosTicket> privateCredentials = clientSubject.getPrivateCredentials(KerberosTicket.class);
        TestSpnegoHttpServer.assertFalse((boolean)privateCredentials.isEmpty());
        KerberosTicket tgt = privateCredentials.iterator().next();
        TestSpnegoHttpServer.assertNotNull((Object)tgt);
        final String principalName = clientPrincipals.iterator().next().getName();
        HttpResponse resp = Subject.doAs(clientSubject, new PrivilegedExceptionAction<HttpResponse>(){

            @Override
            public HttpResponse run() throws Exception {
                GSSManager gssManager = GSSManager.getInstance();
                Oid oid = new Oid("1.2.840.113554.1.2.2");
                GSSName gssClient = gssManager.createName(principalName, GSSName.NT_USER_NAME);
                GSSCredential credential = gssManager.createCredential(gssClient, 0, oid, 1);
                HttpClientContext context = HttpClientContext.create();
                Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
                CloseableHttpClient client = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry).build();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(credential));
                URL url = new URL(HttpServerFunctionalTest.getServerURL(server), "/echo?a=b");
                context.setTargetHost(new HttpHost(url.getHost(), url.getPort()));
                context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                context.setAuthSchemeRegistry((Lookup)authRegistry);
                HttpGet get = new HttpGet(url.toURI());
                return client.execute((HttpUriRequest)get, (HttpContext)context);
            }
        });
        TestSpnegoHttpServer.assertNotNull((Object)resp);
        TestSpnegoHttpServer.assertEquals((long)200L, (long)resp.getStatusLine().getStatusCode());
        TestSpnegoHttpServer.assertEquals((Object)"a:b", (Object)EntityUtils.toString((HttpEntity)resp.getEntity()).trim());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingConfigurationThrowsException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hbase.http.max.threads", 16);
        conf.set("hbase.security.authentication", "kerberos");
        HttpServer customServer = TestSpnegoHttpServer.createTestServerWithSecurity(conf);
        customServer.addServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        customServer.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        customServer.start();
    }
}

