/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.impl.TerminalImpl;
import org.apache.hadoop.hbase.hbtop.terminal.impl.batch.BatchTerminal;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Screen
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Screen.class);
    private static final long SLEEP_TIMEOUT_MILLISECONDS = 100L;
    private final Connection connection;
    private final Admin admin;
    private final Terminal terminal;
    private ScreenView currentScreenView;
    private Long timerTimestamp;

    public Screen(Configuration conf, long initialRefreshDelay, Mode initialMode, @Nullable List<Field> initialFields, @Nullable Field initialSortField, @Nullable Boolean initialAscendingSort, @Nullable List<RecordFilter> initialFilters, long numberOfIterations, boolean batchMode) throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
        this.admin = this.connection.getAdmin();
        this.terminal = batchMode ? new BatchTerminal() : new TerminalImpl("hbtop");
        this.currentScreenView = new TopScreenView(this, this.terminal, initialRefreshDelay, this.admin, initialMode, initialFields, initialSortField, initialAscendingSort, initialFilters, numberOfIterations);
    }

    @Override
    public void close() throws IOException {
        try {
            this.admin.close();
        }
        finally {
            try {
                this.connection.close();
            }
            finally {
                this.terminal.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.currentScreenView.init();
        while (true) {
            try {
                while (true) {
                    ScreenView nextScreenView;
                    block10: {
                        KeyPress keyPress;
                        if ((keyPress = this.terminal.pollKeyPress()) != null) {
                            nextScreenView = this.currentScreenView.handleKeyPress(keyPress);
                        } else {
                            if (this.timerTimestamp != null) {
                                long now = EnvironmentEdgeManager.currentTime();
                                if (this.timerTimestamp <= now) {
                                    this.timerTimestamp = null;
                                    nextScreenView = this.currentScreenView.handleTimer();
                                    break block10;
                                } else {
                                    TimeUnit.MILLISECONDS.sleep(Math.min(this.timerTimestamp - now, 100L));
                                    continue;
                                }
                            }
                            TimeUnit.MILLISECONDS.sleep(100L);
                            continue;
                        }
                    }
                    if (nextScreenView == null) {
                        return;
                    }
                    if (nextScreenView == this.currentScreenView) continue;
                    this.currentScreenView = nextScreenView;
                    this.currentScreenView.init();
                }
            }
            catch (Exception e) {
                LOGGER.error("Caught an exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setTimer(long delay) {
        this.timerTimestamp = EnvironmentEdgeManager.currentTime() + delay;
    }

    public void cancelTimer() {
        this.timerTimestamp = null;
    }
}

