/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsMasterQuotaSource;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@InterfaceAudience.Private
public class MetricsMasterQuotaSourceImpl
extends BaseSourceImpl
implements MetricsMasterQuotaSource {
    private final MetricsMasterWrapper wrapper;
    private final MutableGaugeLong spaceQuotasGauge;
    private final MutableGaugeLong tablesViolatingQuotasGauge;
    private final MutableGaugeLong namespacesViolatingQuotasGauge;
    private final MutableGaugeLong regionSpaceReportsGauge;
    private final MetricHistogram quotaObserverTimeHisto;

    public MetricsMasterQuotaSourceImpl(MetricsMasterWrapper wrapper) {
        this("Quotas", "Metrics about HBase Quotas by the Master", "master", "Master,sub=Quotas", wrapper);
    }

    public MetricsMasterQuotaSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.spaceQuotasGauge = this.getMetricsRegistry().newGauge("numSpaceQuotas", "Number of space quotas defined", 0L);
        this.tablesViolatingQuotasGauge = this.getMetricsRegistry().newGauge("numTablesInQuotaViolation", "Number of tables violating space quotas", 0L);
        this.namespacesViolatingQuotasGauge = this.getMetricsRegistry().newGauge("numNamespaceInQuotaViolation", "Number of namespaces violating space quotas", 0L);
        this.regionSpaceReportsGauge = this.getMetricsRegistry().newGauge("numRegionSizeReports", "Number of Region sizes reported", 0L);
        this.quotaObserverTimeHisto = this.getMetricsRegistry().newTimeHistogram("quotaObserverChoreTime", "Histogram for the time in millis for the QuotaObserverChore");
    }

    public void updateNumSpaceQuotas(long numSpaceQuotas) {
        this.spaceQuotasGauge.set(numSpaceQuotas);
    }

    public void updateNumTablesInSpaceQuotaViolation(long numTablesInViolation) {
        this.tablesViolatingQuotasGauge.set(numTablesInViolation);
    }

    public void updateNumNamespacesInSpaceQuotaViolation(long numNamespacesInViolation) {
        this.namespacesViolatingQuotasGauge.set(numNamespacesInViolation);
    }

    public void updateNumCurrentSpaceQuotaRegionSizeReports(long numCurrentRegionSizeReports) {
        this.regionSpaceReportsGauge.set(numCurrentRegionSizeReports);
    }

    public void incrementSpaceQuotaObserverChoreTime(long time) {
        this.quotaObserverTimeHisto.add(time);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder record = metricsCollector.addRecord(this.metricsRegistry.info());
        if (this.wrapper != null) {
            Map tableUsages = this.wrapper.getTableSpaceUtilization();
            String tableSummary = "[]";
            if (tableUsages != null && !tableUsages.isEmpty()) {
                tableSummary = this.generateJsonQuotaSummary(tableUsages.entrySet(), "table");
            }
            record.tag(Interns.info((String)"tableSpaceQuotaOverview", (String)"A JSON summary of the usage of all tables with space quotas"), tableSummary);
            String nsSummary = "[]";
            Map namespaceUsages = this.wrapper.getNamespaceSpaceUtilization();
            if (namespaceUsages != null && !namespaceUsages.isEmpty()) {
                nsSummary = this.generateJsonQuotaSummary(namespaceUsages.entrySet(), "namespace");
            }
            record.tag(Interns.info((String)"namespaceSpaceQuotaOverview", (String)"A JSON summary of the usage of all namespaces with space quotas"), nsSummary);
        }
        this.metricsRegistry.snapshot(record, all);
    }

    private String generateJsonQuotaSummary(Iterable<Map.Entry<String, Map.Entry<Long, Long>>> data, String target) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map.Entry<Long, Long>> tableUsage : data) {
            String tableName = tableUsage.getKey();
            long usage = tableUsage.getValue().getKey();
            long limit = tableUsage.getValue().getValue();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("{").append(target).append("=").append(tableName).append(", usage=").append(usage).append(", limit=").append(limit).append("}");
        }
        sb.insert(0, "[").append("]");
        return sb.toString();
    }
}

