/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
public class MetricsRegionServerSourceImpl
extends BaseSourceImpl
implements MetricsRegionServerSource {
    final MetricsRegionServerWrapper rsWrap;
    private final MetricHistogram putHisto;
    private final MetricHistogram deleteHisto;
    private final MetricHistogram getHisto;
    private final MetricHistogram incrementHisto;
    private final MetricHistogram appendHisto;
    private final MetricHistogram replayHisto;
    private final MutableCounterLong slowPut;
    private final MutableCounterLong slowDelete;
    private final MutableCounterLong slowGet;
    private final MutableCounterLong slowIncrement;
    private final MutableCounterLong slowAppend;

    public MetricsRegionServerSourceImpl(MetricsRegionServerWrapper rsWrap) {
        this("Server", "Metrics about HBase RegionServer", "regionserver", "RegionServer,sub=Server", rsWrap);
    }

    public MetricsRegionServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsRegionServerWrapper rsWrap) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.rsWrap = rsWrap;
        this.putHisto = this.getMetricsRegistry().newHistogram("mutate");
        this.slowPut = this.getMetricsRegistry().newCounter("slowPutCount", "The number of Multis that took over 1000ms to complete", 0L);
        this.deleteHisto = this.getMetricsRegistry().newHistogram("delete");
        this.slowDelete = this.getMetricsRegistry().newCounter("slowDeleteCount", "The number of Deletes that took over 1000ms to complete", 0L);
        this.getHisto = this.getMetricsRegistry().newHistogram("get");
        this.slowGet = this.getMetricsRegistry().newCounter("slowGetCount", "The number of Gets that took over 1000ms to complete", 0L);
        this.incrementHisto = this.getMetricsRegistry().newHistogram("increment");
        this.slowIncrement = this.getMetricsRegistry().newCounter("slowIncrementCount", "The number of Increments that took over 1000ms to complete", 0L);
        this.appendHisto = this.getMetricsRegistry().newHistogram("append");
        this.slowAppend = this.getMetricsRegistry().newCounter("slowAppendCount", "The number of Appends that took over 1000ms to complete", 0L);
        this.replayHisto = this.getMetricsRegistry().newHistogram("replay");
    }

    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    public void updateGet(long t) {
        this.getHisto.add(t);
    }

    public void updateIncrement(long t) {
        this.incrementHisto.add(t);
    }

    public void updateAppend(long t) {
        this.appendHisto.add(t);
    }

    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    public void incrSlowPut() {
        this.slowPut.incr();
    }

    public void incrSlowDelete() {
        this.slowDelete.incr();
    }

    public void incrSlowGet() {
        this.slowGet.incr();
    }

    public void incrSlowIncrement() {
        this.slowIncrement.incr();
    }

    public void incrSlowAppend() {
        this.slowAppend.incr();
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName).setContext(this.metricsContext);
        if (this.rsWrap != null) {
            mrb.addGauge(Interns.info((String)"regionCount", (String)"Number of regions"), this.rsWrap.getNumOnlineRegions()).addGauge(Interns.info((String)"storeCount", (String)"Number of Stores"), this.rsWrap.getNumStores()).addGauge(Interns.info((String)"hlogFileCount", (String)"Number of HLog Files"), this.rsWrap.getNumHLogFiles()).addGauge(Interns.info((String)"hlogFileSize", (String)"Size of all HLog Files"), this.rsWrap.getHLogFileSize()).addGauge(Interns.info((String)"storeFileCount", (String)"Number of Store Files"), this.rsWrap.getNumStoreFiles()).addGauge(Interns.info((String)"memStoreSize", (String)"Size of the memstore"), this.rsWrap.getMemstoreSize()).addGauge(Interns.info((String)"storeFileSize", (String)"Size of storefiles being served."), this.rsWrap.getStoreFileSize()).addGauge(Interns.info((String)"regionServerStartTime", (String)"RegionServer Start Time"), this.rsWrap.getStartCode()).addCounter(Interns.info((String)"totalRequestCount", (String)"Total number of requests this RegionServer has answered."), this.rsWrap.getTotalRequestCount()).addCounter(Interns.info((String)"readRequestCount", (String)"Number of read requests this region server has answered."), this.rsWrap.getReadRequestsCount()).addCounter(Interns.info((String)"writeRequestCount", (String)"Number of mutation requests this region server has answered."), this.rsWrap.getWriteRequestsCount()).addCounter(Interns.info((String)"checkMutateFailedCount", (String)"Number of Check and Mutate calls that failed the checks."), this.rsWrap.getCheckAndMutateChecksFailed()).addCounter(Interns.info((String)"checkMutatePassedCount", (String)"Number of Check and Mutate calls that passed the checks."), this.rsWrap.getCheckAndMutateChecksPassed()).addGauge(Interns.info((String)"storeFileIndexSize", (String)"Size of indexes in storefiles on disk."), this.rsWrap.getStoreFileIndexSize()).addGauge(Interns.info((String)"staticIndexSize", (String)"Uncompressed size of the static indexes."), this.rsWrap.getTotalStaticIndexSize()).addGauge(Interns.info((String)"staticBloomSize", (String)"Uncompressed size of the static bloom filters."), this.rsWrap.getTotalStaticBloomSize()).addGauge(Interns.info((String)"mutationsWithoutWALCount", (String)"Number of mutations that have been sent by clients with the write ahead logging turned off."), this.rsWrap.getNumMutationsWithoutWAL()).addGauge(Interns.info((String)"mutationsWithoutWALSize", (String)"Size of data that has been sent by clients with the write ahead logging turned off."), this.rsWrap.getDataInMemoryWithoutWAL()).addGauge(Interns.info((String)"percentFilesLocal", (String)"The percent of HFiles that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocal()).addGauge(Interns.info((String)"compactionQueueLength", (String)"Length of the queue for compactions."), this.rsWrap.getCompactionQueueSize()).addGauge(Interns.info((String)"flushQueueLength", (String)"Length of the queue for region flushes"), this.rsWrap.getFlushQueueSize()).addGauge(Interns.info((String)"blockCacheFreeSize", (String)"Size of the block cache that is not occupied."), this.rsWrap.getBlockCacheFreeSize()).addGauge(Interns.info((String)"blockCacheCount", (String)"Number of block in the block cache."), this.rsWrap.getBlockCacheCount()).addGauge(Interns.info((String)"blockCacheSize", (String)"Size of the block cache."), this.rsWrap.getBlockCacheSize()).addCounter(Interns.info((String)"blockCacheHitCount", (String)"Count of the hit on the block cache."), this.rsWrap.getBlockCacheHitCount()).addCounter(Interns.info((String)"blockCacheMissCount", (String)"Number of requests for a block that missed the block cache."), this.rsWrap.getBlockCacheMissCount()).addCounter(Interns.info((String)"blockCacheEvictionCount", (String)"Count of the number of blocks evicted from the block cache."), this.rsWrap.getBlockCacheEvictedCount()).addGauge(Interns.info((String)"blockCountHitPercent", (String)"Percent of block cache requests that are hits"), this.rsWrap.getBlockCacheHitPercent()).addGauge(Interns.info((String)"blockCacheExpressHitPercent", (String)"The percent of the time that requests with the cache turned on hit the cache."), this.rsWrap.getBlockCacheHitCachingPercent()).addCounter(Interns.info((String)"updatesBlockedTime", (String)"Number of MS updates have been blocked so that the memstore can be flushed."), this.rsWrap.getUpdatesBlockedTime()).addCounter(Interns.info((String)"flushedCellsCount", (String)"The number of cells flushed to disk"), this.rsWrap.getFlushedCellsCount()).addCounter(Interns.info((String)"compactedCellsCount", (String)"The number of cells processed during minor compactions"), this.rsWrap.getCompactedCellsCount()).addCounter(Interns.info((String)"majorCompactedCellsCount", (String)"The number of cells processed during major compactions"), this.rsWrap.getMajorCompactedCellsCount()).addCounter(Interns.info((String)"flushedCellsSize", (String)"The total amount of data flushed to disk, in bytes"), this.rsWrap.getFlushedCellsSize()).addCounter(Interns.info((String)"compactedCellsSize", (String)"The total amount of data processed during minor compactions, in bytes"), this.rsWrap.getCompactedCellsSize()).addCounter(Interns.info((String)"majorCompactedCellsSize", (String)"The total amount of data processed during major compactions, in bytes"), this.rsWrap.getMajorCompactedCellsSize()).tag(Interns.info((String)"zookeeperQuorum", (String)"Zookeeper Quorum"), this.rsWrap.getZookeeperQuorum()).tag(Interns.info((String)"serverName", (String)"Server Name"), this.rsWrap.getServerName()).tag(Interns.info((String)"clusterId", (String)"Cluster Id"), this.rsWrap.getClusterId());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

