/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationSourceSourceImpl
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final String id;
    private final String sizeOfLogQueueKey;
    private final String ageOfLastShippedOpKey;
    private final String logReadInEditsKey;
    private final String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private String keyPrefix;
    @Deprecated
    private final String shippedKBsKey;
    private final String shippedBytesKey;
    private final String logReadInBytesKey;
    private final MutableGaugeLong ageOfLastShippedOpGauge;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableCounterLong logReadInEditsCounter;
    private final MutableCounterLong logEditsFilteredCounter;
    private final MutableCounterLong shippedBatchesCounter;
    private final MutableCounterLong shippedOpsCounter;
    private final MutableCounterLong shippedKBsCounter;
    private final MutableCounterLong shippedBytesCounter;
    private final MutableCounterLong logReadInBytesCounter;

    public MetricsReplicationSourceSourceImpl(MetricsReplicationSourceImpl rms, String id) {
        this.rms = rms;
        this.id = id;
        this.keyPrefix = "source." + this.id + ".";
        this.ageOfLastShippedOpKey = this.keyPrefix + "ageOfLastShippedOp";
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getLongGauge(this.ageOfLastShippedOpKey, 0L);
        this.sizeOfLogQueueKey = this.keyPrefix + "sizeOfLogQueue";
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getLongGauge(this.sizeOfLogQueueKey, 0L);
        this.shippedBatchesKey = this.keyPrefix + "shippedBatches";
        this.shippedBatchesCounter = rms.getMetricsRegistry().getLongCounter(this.shippedBatchesKey, 0L);
        this.shippedOpsKey = this.keyPrefix + "shippedOps";
        this.shippedOpsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedOpsKey, 0L);
        this.shippedKBsKey = this.keyPrefix + "shippedKBs";
        this.shippedKBsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedKBsKey, 0L);
        this.shippedBytesKey = this.keyPrefix + "shippedBytes";
        this.shippedBytesCounter = rms.getMetricsRegistry().getLongCounter(this.shippedBytesKey, 0L);
        this.logReadInBytesKey = this.keyPrefix + "logReadInBytes";
        this.logReadInBytesCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInBytesKey, 0L);
        this.logReadInEditsKey = this.keyPrefix + "logEditsRead";
        this.logReadInEditsCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInEditsKey, 0L);
        this.logEditsFilteredKey = this.keyPrefix + "logEditsFiltered";
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getLongCounter(this.logEditsFilteredKey, 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
    }

    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set((long)size);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr((long)batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedBytes(long size) {
        MetricsReplicationGlobalSourceSource.incrementKBsCounter(size, this.shippedBytesCounter, this.shippedKBsCounter);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.sizeOfLogQueueKey);
        this.rms.removeMetric(this.shippedBatchesKey);
        this.rms.removeMetric(this.shippedOpsKey);
        this.rms.removeMetric(this.shippedKBsKey);
        this.rms.removeMetric(this.shippedBytesKey);
        this.rms.removeMetric(this.logReadInBytesKey);
        this.rms.removeMetric(this.logReadInEditsKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpGauge.value();
    }

    public void init() {
        this.rms.init();
    }

    public void setGauge(String gaugeName, long value) {
        this.rms.setGauge(this.keyPrefix + gaugeName, value);
    }

    public void incGauge(String gaugeName, long delta) {
        this.rms.incGauge(this.keyPrefix + gaugeName, delta);
    }

    public void decGauge(String gaugeName, long delta) {
        this.rms.decGauge(this.keyPrefix + gaugeName, delta);
    }

    public void removeMetric(String key) {
        this.rms.removeMetric(this.keyPrefix + key);
    }

    public void incCounters(String counterName, long delta) {
        this.rms.incCounters(this.keyPrefix + counterName, delta);
    }

    public void updateHistogram(String name, long value) {
        this.rms.updateHistogram(this.keyPrefix + name, value);
    }

    public void updateQuantile(String name, long value) {
        this.rms.updateQuantile(this.keyPrefix + name, value);
    }

    public String getMetricsContext() {
        return this.rms.getMetricsContext();
    }

    public String getMetricsDescription() {
        return this.rms.getMetricsDescription();
    }

    public String getMetricsJmxContext() {
        return this.rms.getMetricsJmxContext();
    }

    public String getMetricsName() {
        return this.rms.getMetricsName();
    }
}

