/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
public class MetricsMasterSourceImpl
extends BaseSourceImpl
implements MetricsMasterSource {
    private final MetricsMasterWrapper masterWrapper;
    private MutableCounterLong clusterRequestsCounter;
    private final MutableCounterLong infoPauseThresholdExceeded;
    private final MutableCounterLong warnPauseThresholdExceeded;
    private final MetricHistogram pausesWithGc;
    private final MetricHistogram pausesWithoutGc;

    public MetricsMasterSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Server", "Metrics about HBase master server", "master", "Master,sub=Server", masterWrapper);
    }

    public MetricsMasterSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
        this.infoPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseInfoThresholdExceeded", "Count of INFO level pause threshold alerts", 0L);
        this.warnPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseWarnThresholdExceeded", "Count of WARN level pause threshold alerts", 0L);
        this.pausesWithGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithGc");
        this.pausesWithoutGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithoutGc");
    }

    @Override
    public void init() {
        super.init();
        this.clusterRequestsCounter = this.metricsRegistry.newCounter("clusterRequests", "", 0L);
    }

    public void incRequests(int inc) {
        this.clusterRequestsCounter.incr((long)inc);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName).setContext(this.metricsContext);
        if (this.masterWrapper != null) {
            metricsRecordBuilder.addGauge(Interns.info("masterActiveTime", "Master Active Time"), this.masterWrapper.getActiveTime()).addGauge(Interns.info("masterStartTime", "Master Start Time"), this.masterWrapper.getStartTime()).addGauge(Interns.info("averageLoad", "AverageLoad"), this.masterWrapper.getAverageLoad()).tag(Interns.info("liveRegionServers", "Names of live RegionServers"), this.masterWrapper.getRegionServers()).addGauge(Interns.info("numRegionServers", "Number of RegionServers"), this.masterWrapper.getNumRegionServers()).tag(Interns.info("deadRegionServers", "Names of dead RegionServers"), this.masterWrapper.getDeadRegionServers()).addGauge(Interns.info("numDeadRegionServers", "Number of dead RegionServers"), this.masterWrapper.getNumDeadRegionServers()).tag(Interns.info("zookeeperQuorum", "Zookeeper Quorum"), this.masterWrapper.getZookeeperQuorum()).tag(Interns.info("serverName", "Server Name"), this.masterWrapper.getServerName()).tag(Interns.info("clusterId", "Cluster Id"), this.masterWrapper.getClusterId()).tag(Interns.info("isActiveMaster", "Is Active Master"), String.valueOf(this.masterWrapper.getIsActiveMaster()));
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
    }

    public void incInfoThresholdExceeded(int count) {
        this.infoPauseThresholdExceeded.incr((long)count);
    }

    public void incWarnThresholdExceeded(int count) {
        this.warnPauseThresholdExceeded.incr((long)count);
    }

    public void updatePauseTimeWithGc(long t) {
        this.pausesWithGc.add(t);
    }

    public void updatePauseTimeWithoutGc(long t) {
        this.pausesWithoutGc.add(t);
    }
}

