/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSinkSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationSinkSourceImpl
implements MetricsReplicationSinkSource {
    private final MutableGaugeLong ageGauge;
    private final MutableCounterLong batchesCounter;
    private final MutableCounterLong opsCounter;

    public MetricsReplicationSinkSourceImpl(MetricsReplicationSourceImpl rms) {
        this.ageGauge = rms.getMetricsRegistry().getLongGauge("sink.ageOfLastAppliedOp", 0L);
        this.batchesCounter = rms.getMetricsRegistry().getLongCounter("sink.appliedBatches", 0L);
        this.opsCounter = rms.getMetricsRegistry().getLongCounter("sink.appliedOps", 0L);
    }

    public void setLastAppliedOpAge(long age) {
        this.ageGauge.set(age);
    }

    public void incrAppliedBatches(long batches) {
        this.batchesCounter.incr(batches);
    }

    public void incrAppliedOps(long batchsize) {
        this.opsCounter.incr(batchsize);
    }
}

