/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSource;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableStat;

public class MetricsThriftServerSourceImpl
extends BaseSourceImpl
implements MetricsThriftServerSource {
    private MutableStat batchGetStat;
    private MutableStat batchMutateStat;
    private MutableStat queueTimeStat;
    private MutableStat thriftCallStat;
    private MutableStat thriftSlowCallStat;
    private MutableGaugeLong callQueueLenGauge;

    public MetricsThriftServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.batchGetStat = this.getMetricsRegistry().newStat("batchGet", "", "Keys", "Ops");
        this.batchMutateStat = this.getMetricsRegistry().newStat("batchMutate", "", "Keys", "Ops");
        this.queueTimeStat = this.getMetricsRegistry().newRate("timeInQueue");
        this.thriftCallStat = this.getMetricsRegistry().newRate("thriftCall");
        this.thriftSlowCallStat = this.getMetricsRegistry().newRate("slowThriftCall");
        this.callQueueLenGauge = this.getMetricsRegistry().getLongGauge("callQueueLen", 0L);
    }

    public void incTimeInQueue(long time) {
        this.queueTimeStat.add(time);
    }

    public void setCallQueueLen(int len) {
        this.callQueueLenGauge.set((long)len);
    }

    public void incNumRowKeysInBatchGet(int diff) {
        this.batchGetStat.add((long)diff);
    }

    public void incNumRowKeysInBatchMutate(int diff) {
        this.batchMutateStat.add((long)diff);
    }

    public void incMethodTime(String name, long time) {
        MutableRate s = this.getMetricsRegistry().newRate(name);
        s.add(time);
    }

    public void incCall(long time) {
        this.thriftCallStat.add(time);
    }

    public void incSlowCall(long time) {
        this.thriftSlowCallStat.add(time);
    }
}

