/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSourceImpl;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;

public class MetricsRegionAggregateSourceImpl
extends BaseSourceImpl
implements MetricsRegionAggregateSource {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final TreeSet<MetricsRegionSourceImpl> regionSources = new TreeSet();

    public MetricsRegionAggregateSourceImpl() {
        this("Regions", "Metrics about HBase RegionServer regions and tables", "regionserver", "RegionServer,sub=Regions");
    }

    public MetricsRegionAggregateSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MetricsRegionSource source) {
        this.lock.writeLock().lock();
        try {
            this.regionSources.add((MetricsRegionSourceImpl)source);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(MetricsRegionSource source) {
        this.lock.writeLock().lock();
        try {
            this.regionSources.remove(source);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder mrb = collector.addRecord(this.metricsName).setContext(this.metricsContext);
        if (this.regionSources != null) {
            this.lock.readLock().lock();
            try {
                for (MetricsRegionSourceImpl regionMetricSource : this.regionSources) {
                    regionMetricSource.snapshot(mrb, all);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

