/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricMutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.hadoop.metrics2.source.JvmMetrics;

public class BaseSourceImpl
implements BaseSource,
MetricsSource {
    protected final DynamicMetricsRegistry metricsRegistry;
    protected final String metricsName;
    protected final String metricsDescription;
    protected final String metricsContext;
    protected final String metricsJmxContext;

    public BaseSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        this.metricsName = metricsName;
        this.metricsDescription = metricsDescription;
        this.metricsContext = metricsContext;
        this.metricsJmxContext = metricsJmxContext;
        this.metricsRegistry = new DynamicMetricsRegistry(metricsName).setContext(metricsContext);
        DefaultMetricsSystemInitializer.INSTANCE.init(metricsName);
        DefaultMetricsSystem.instance().register(metricsJmxContext, metricsDescription, (Object)this);
        this.init();
    }

    public void init() {
        this.metricsRegistry.clearMetrics();
    }

    public void setGauge(String gaugeName, long value) {
        MutableGaugeLong gaugeInt = this.metricsRegistry.getLongGauge(gaugeName, value);
        gaugeInt.set(value);
    }

    public void incGauge(String gaugeName, long delta) {
        MutableGaugeLong gaugeInt = this.metricsRegistry.getLongGauge(gaugeName, 0L);
        gaugeInt.incr(delta);
    }

    public void decGauge(String gaugeName, long delta) {
        MutableGaugeLong gaugeInt = this.metricsRegistry.getLongGauge(gaugeName, 0L);
        gaugeInt.decr(delta);
    }

    public void incCounters(String key, long delta) {
        MutableCounterLong counter = this.metricsRegistry.getLongCounter(key, 0L);
        counter.incr(delta);
    }

    public void updateHistogram(String name, long value) {
        MutableHistogram histo = this.metricsRegistry.getHistogram(name);
        histo.add(value);
    }

    public void updateQuantile(String name, long value) {
        MetricMutableQuantiles histo = this.metricsRegistry.getQuantile(name);
        histo.add(value);
    }

    public void removeMetric(String key) {
        this.metricsRegistry.removeMetric(key);
        JmxCacheBuster.clearJmxCache();
    }

    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        this.metricsRegistry.snapshot(metricsCollector.addRecord(this.metricsRegistry.info()), all);
    }

    public DynamicMetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public String getMetricsContext() {
        return this.metricsContext;
    }

    public String getMetricsDescription() {
        return this.metricsDescription;
    }

    public String getMetricsJmxContext() {
        return this.metricsJmxContext;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    private static enum DefaultMetricsSystemInitializer {
        INSTANCE;

        private boolean inited = false;
        private JvmMetrics jvmMetricsSource;

        synchronized void init(String name) {
            if (this.inited) {
                return;
            }
            this.inited = true;
            DefaultMetricsSystem.initialize((String)"HBase");
            this.jvmMetricsSource = JvmMetrics.create((String)name, (String)"", (MetricsSystem)DefaultMetricsSystem.instance());
        }
    }
}

