/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.hadoop.metrics2.lib.MutableStat;

public class MetricsMasterSourceImpl
extends BaseSourceImpl
implements MetricsMasterSource {
    private final MetricsMasterWrapper masterWrapper;
    private MutableCounterLong clusterRequestsCounter;
    private MutableGaugeLong ritGauge;
    private MutableGaugeLong ritCountOverThresholdGauge;
    private MutableGaugeLong ritOldestAgeGauge;
    private MutableHistogram splitTimeHisto;
    private MutableHistogram splitSizeHisto;
    private MutableStat snapshotTimeHisto;
    private MutableStat snapshotCloneTimeHisto;
    private MutableStat snapshotRestoreTimeHisto;
    private MutableHistogram metaSplitTimeHisto;
    private MutableHistogram metaSplitSizeHisto;

    public MetricsMasterSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Server", "Metrics about HBase master server", "master", "Master,sub=Server", masterWrapper);
    }

    public MetricsMasterSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
    }

    @Override
    public void init() {
        super.init();
        this.clusterRequestsCounter = this.metricsRegistry.newCounter("clusterRequests", "", 0L);
        this.ritGauge = this.metricsRegistry.newGauge("ritCount", "", 0L);
        this.ritCountOverThresholdGauge = this.metricsRegistry.newGauge("ritCountOverThreshold", "", 0L);
        this.ritOldestAgeGauge = this.metricsRegistry.newGauge("ritOldestAge", "", 0L);
        this.splitSizeHisto = this.metricsRegistry.newHistogram("hlogSplitSize", "Size of HLog files being split");
        this.splitTimeHisto = this.metricsRegistry.newHistogram("hlogSplitTime", "Time it takes to finish HLog.splitLog()");
        this.snapshotTimeHisto = this.metricsRegistry.newStat("snapshotTime", "Time it takes to finish snapshot()", "Ops", "Time", true);
        this.snapshotCloneTimeHisto = this.metricsRegistry.newStat("snapshotCloneTime", "Time it takes to finish cloneSnapshot()", "Ops", "Time", true);
        this.snapshotRestoreTimeHisto = this.metricsRegistry.newStat("snapshotRestoreTime", "Time it takes to finish restoreSnapshot()", "Ops", "Time", true);
        this.metaSplitTimeHisto = this.metricsRegistry.newHistogram("metaHlogSplitTime", "Time it takes to finish splitMetaLog()");
        this.metaSplitSizeHisto = this.metricsRegistry.newHistogram("metaHlogSplitSize", "Size of META HLog files being split");
    }

    public void incRequests(int inc) {
        this.clusterRequestsCounter.incr((long)inc);
    }

    public void setRIT(int ritCount) {
        this.ritGauge.set((long)ritCount);
    }

    public void setRITCountOverThreshold(int ritCount) {
        this.ritCountOverThresholdGauge.set((long)ritCount);
    }

    public void setRITOldestAge(long ritCount) {
        this.ritOldestAgeGauge.set(ritCount);
    }

    public void updateSplitTime(long time) {
        this.splitTimeHisto.add(time);
    }

    public void updateSplitSize(long size) {
        this.splitSizeHisto.add(size);
    }

    public void updateSnapshotTime(long time) {
        this.snapshotTimeHisto.add(time);
    }

    public void updateSnapshotCloneTime(long time) {
        this.snapshotCloneTimeHisto.add(time);
    }

    public void updateSnapshotRestoreTime(long time) {
        this.snapshotRestoreTimeHisto.add(time);
    }

    public void updateMetaWALSplitTime(long time) {
        this.metaSplitTimeHisto.add(time);
    }

    public void updateMetaWALSplitSize(long size) {
        this.metaSplitSizeHisto.add(size);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName).setContext(this.metricsContext);
        if (this.masterWrapper != null) {
            metricsRecordBuilder.addGauge(Interns.info((String)"masterActiveTime", (String)"Master Active Time"), this.masterWrapper.getActiveTime()).addGauge(Interns.info((String)"masterStartTime", (String)"Master Start Time"), this.masterWrapper.getStartTime()).addGauge(Interns.info((String)"averageLoad", (String)"AverageLoad"), this.masterWrapper.getAverageLoad()).addGauge(Interns.info((String)"numRegionServers", (String)"Number of RegionServers"), this.masterWrapper.getRegionServers()).addGauge(Interns.info((String)"numDeadRegionServers", (String)"Number of dead RegionServers"), this.masterWrapper.getDeadRegionServers()).tag(Interns.info((String)"zookeeperQuorum", (String)"Zookeeper Quorum"), this.masterWrapper.getZookeeperQuorum()).tag(Interns.info((String)"serverName", (String)"Server Name"), this.masterWrapper.getServerName()).tag(Interns.info((String)"clusterId", (String)"Cluster Id"), this.masterWrapper.getClusterId()).tag(Interns.info((String)"isActiveMaster", (String)"Is Active Master"), String.valueOf(this.masterWrapper.getIsActiveMaster()));
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
    }
}

