/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilityFactory;

public class CompatibilitySingletonFactory
extends CompatibilityFactory {
    private static final Log LOG = LogFactory.getLog(CompatibilitySingletonFactory.class);
    private static final Map<Class, Object> instances = new HashMap<Class, Object>();

    protected CompatibilitySingletonFactory() {
    }

    public static synchronized <T> T getInstance(Class<T> klass) {
        Object instance = instances.get(klass);
        if (instance == null) {
            try {
                ServiceLoader<T> loader = ServiceLoader.load(klass);
                Iterator<T> it = loader.iterator();
                instance = it.next();
                if (it.hasNext()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("ServiceLoader provided more than one implementation for class: ").append(klass).append(", using implementation: ").append(instance.getClass()).append(", other implementations: {");
                    while (it.hasNext()) {
                        msg.append(it.next()).append(" ");
                    }
                    msg.append("}");
                    LOG.warn((Object)msg);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(CompatibilitySingletonFactory.createExceptionString(klass), e);
            }
            catch (Error e) {
                throw new RuntimeException(CompatibilitySingletonFactory.createExceptionString(klass), e);
            }
            if (instance == null) {
                throw new RuntimeException(CompatibilitySingletonFactory.createExceptionString(klass));
            }
            instances.put(klass, instance);
        }
        return (T)instance;
    }
}

