/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Counter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestCounter {
    private static final int[] THREAD_COUNTS = new int[]{1, 10, 100};
    private static final int DATA_COUNT = 1000000;

    @Test
    public void testIncrement() throws Exception {
        for (int threadCount : THREAD_COUNTS) {
            final Counter counter = new Counter();
            TestCounter.execute(new Operation(){

                @Override
                public void execute() {
                    counter.increment();
                }
            }, threadCount);
            Assert.assertEquals((long)((long)threadCount * 1000000L), (long)counter.get());
        }
    }

    @Test
    public void testIncrementAndGet() throws Exception {
        for (int threadCount : THREAD_COUNTS) {
            final Counter counter = new Counter();
            TestCounter.execute(new Operation(){

                @Override
                public void execute() {
                    counter.increment();
                    counter.get();
                }
            }, threadCount);
            Assert.assertEquals((long)((long)threadCount * 1000000L), (long)counter.get());
        }
    }

    private static void execute(final Operation op, int threadCount) throws InterruptedException {
        final CountDownLatch prepareLatch = new CountDownLatch(threadCount);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(threadCount);
        for (int j = 0; j < threadCount; ++j) {
            class OperationThread
            extends Thread {
                OperationThread() {
                }

                @Override
                public void run() {
                    try {
                        prepareLatch.countDown();
                        startLatch.await();
                        for (int i = 0; i < 1000000; ++i) {
                            op.execute();
                        }
                        endLatch.countDown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            new OperationThread().start();
        }
        prepareLatch.await();
        startLatch.countDown();
        endLatch.await();
    }

    private static interface Operation {
        public void execute();
    }
}

