/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupCopyJob;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupRestoreFactory;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.impl.BackupAdminImpl;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hadoop.hbase.backup.impl.BulkLoad;
import org.apache.hadoop.hbase.backup.impl.ColumnFamilyMismatchException;
import org.apache.hadoop.hbase.backup.impl.IncrementalBackupManager;
import org.apache.hadoop.hbase.backup.impl.MergeSplitBulkloadInfo;
import org.apache.hadoop.hbase.backup.impl.TableBackupClient;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceHFileSplitterJob;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotRegionLocator;
import org.apache.hadoop.hbase.snapshot.SnapshotTTLExpiredException;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class IncrementalTableBackupClient
extends TableBackupClient {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalTableBackupClient.class);

    protected IncrementalTableBackupClient() {
    }

    public IncrementalTableBackupClient(Connection conn, String backupId, BackupRequest request) throws IOException {
        super(conn, backupId, request);
    }

    protected List<String> filterMissingFiles(List<String> incrBackupFileList) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (String file : incrBackupFileList) {
            Path p = new Path(file);
            if (this.fs.exists(p) || this.isActiveWalPath(p)) {
                list.add(file);
                continue;
            }
            LOG.warn("Can't find file: " + file);
        }
        return list;
    }

    protected boolean isActiveWalPath(Path p) {
        return !AbstractFSWALProvider.isArchivedLogFile((Path)p);
    }

    protected static int getIndex(TableName tbl, List<TableName> sTableList) {
        if (sTableList == null) {
            return 0;
        }
        for (int i = 0; i < sTableList.size(); ++i) {
            if (!tbl.equals((Object)sTableList.get(i))) continue;
            return i;
        }
        return -1;
    }

    protected List<BulkLoad> handleBulkLoad(List<TableName> tablesToBackup) throws IOException {
        FileSystem tgtFs;
        HashMap<TableName, MergeSplitBulkloadInfo> toBulkload = new HashMap<TableName, MergeSplitBulkloadInfo>();
        List<BulkLoad> bulkLoads = this.backupManager.readBulkloadRows(tablesToBackup);
        try {
            tgtFs = FileSystem.get((URI)new URI(this.backupInfo.getBackupRootDir()), (Configuration)this.conf);
        }
        catch (URISyntaxException use) {
            throw new IOException("Unable to get FileSystem", use);
        }
        Path rootdir = CommonFSUtils.getRootDir((Configuration)this.conf);
        Path tgtRoot = new Path(new Path(this.backupInfo.getBackupRootDir()), this.backupId);
        for (BulkLoad bulkLoad : bulkLoads) {
            TableName srcTable = bulkLoad.getTableName();
            MergeSplitBulkloadInfo bulkloadInfo = toBulkload.computeIfAbsent(srcTable, MergeSplitBulkloadInfo::new);
            String regionName = bulkLoad.getRegion();
            String fam = bulkLoad.getColumnFamily();
            String filename = FilenameUtils.getName((String)bulkLoad.getHfilePath());
            if (!tablesToBackup.contains(srcTable)) {
                LOG.debug("Skipping {} since it is not in tablesToBackup", (Object)srcTable);
                continue;
            }
            Path tblDir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)srcTable);
            Path p = new Path(tblDir, regionName + "/" + fam + "/" + filename);
            String srcTableQualifier = srcTable.getQualifierAsString();
            String srcTableNs = srcTable.getNamespaceAsString();
            Path tgtFam = new Path(tgtRoot, srcTableNs + "/" + srcTableQualifier + "/" + regionName + "/" + fam);
            if (!tgtFs.mkdirs(tgtFam)) {
                throw new IOException("couldn't create " + tgtFam);
            }
            Path tgt = new Path(tgtFam, filename);
            Path archiveDir = HFileArchiveUtil.getStoreArchivePath((Configuration)this.conf, (TableName)srcTable, (String)regionName, (String)fam);
            Path archive = new Path(archiveDir, filename);
            if (this.fs.exists(p)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("found bulk hfile {} in {} for {}", new Object[]{bulkLoad.getHfilePath(), p.getParent(), srcTableQualifier});
                    LOG.trace("copying {} to {}", (Object)p, (Object)tgt);
                }
                bulkloadInfo.addActiveFile(p.toString());
                continue;
            }
            if (!this.fs.exists(archive)) continue;
            LOG.debug("copying archive {} to {}", (Object)archive, (Object)tgt);
            bulkloadInfo.addArchiveFiles(archive.toString());
        }
        for (MergeSplitBulkloadInfo bulkloadInfo : toBulkload.values()) {
            this.mergeSplitAndCopyBulkloadedHFiles(bulkloadInfo.getActiveFiles(), bulkloadInfo.getArchiveFiles(), bulkloadInfo.getSrcTable(), tgtFs);
        }
        return bulkLoads;
    }

    private void mergeSplitAndCopyBulkloadedHFiles(List<String> activeFiles, List<String> archiveFiles, TableName tn, FileSystem tgtFs) throws IOException {
        int attempt = 1;
        while (!activeFiles.isEmpty()) {
            LOG.info("MergeSplit {} active bulk loaded files. Attempt={}", (Object)activeFiles.size(), (Object)attempt++);
            try {
                this.mergeSplitAndCopyBulkloadedHFiles(activeFiles, tn, tgtFs);
                break;
            }
            catch (IOException e) {
                int numActiveFiles = activeFiles.size();
                this.updateFileLists(activeFiles, archiveFiles);
                if (activeFiles.size() < numActiveFiles) {
                    this.deleteBulkLoadDirectory();
                    continue;
                }
                throw e;
            }
        }
        if (!archiveFiles.isEmpty()) {
            this.mergeSplitAndCopyBulkloadedHFiles(archiveFiles, tn, tgtFs);
        }
    }

    private void mergeSplitAndCopyBulkloadedHFiles(List<String> files, TableName tn, FileSystem tgtFs) throws IOException {
        int result;
        MapReduceHFileSplitterJob player = new MapReduceHFileSplitterJob();
        this.conf.set("hfile.bulk.output", this.getBulkOutputDirForTable(tn).toString());
        player.setConf(this.conf);
        String inputDirs = StringUtils.join(files, (String)",");
        String[] args = new String[]{inputDirs, tn.getNameWithNamespaceInclAsString()};
        try {
            result = player.run(args);
        }
        catch (Exception e) {
            LOG.error("Failed to run MapReduceHFileSplitterJob", (Throwable)e);
            this.deleteBulkLoadDirectory();
            throw new IOException(e);
        }
        if (result != 0) {
            throw new IOException("Failed to run MapReduceHFileSplitterJob with invalid result: " + result);
        }
        this.incrementalCopyBulkloadHFiles(tgtFs, tn);
    }

    public void updateFileLists(List<String> activeFiles, List<String> archiveFiles) throws IOException {
        ArrayList<String> newlyArchived = new ArrayList<String>();
        for (String spath : activeFiles) {
            if (this.fs.exists(new Path(spath))) continue;
            newlyArchived.add(spath);
        }
        if (!newlyArchived.isEmpty()) {
            String rootDir = CommonFSUtils.getRootDir((Configuration)this.conf).toString();
            activeFiles.removeAll(newlyArchived);
            for (String file : newlyArchived) {
                String archivedFile = file.substring(rootDir.length() + 1);
                Path archivedFilePath = new Path(HFileArchiveUtil.getArchivePath((Configuration)this.conf), archivedFile);
                archivedFile = archivedFilePath.toString();
                if (!this.fs.exists(archivedFilePath)) {
                    throw new IOException(String.format("File %s no longer exists, and no archived file %s exists for it", file, archivedFile));
                }
                LOG.debug("Archived file {} has been updated", (Object)archivedFile);
                archiveFiles.add(archivedFile);
            }
        }
        LOG.debug(newlyArchived.size() + " files have been archived.");
    }

    @Override
    public void execute() throws IOException, ColumnFamilyMismatchException {
        try {
            Map<TableName, String> tablesToFullBackupIds = this.getFullBackupIds();
            this.verifyCfCompatibility(this.backupInfo.getTables(), tablesToFullBackupIds);
            this.beginBackup(this.backupManager, this.backupInfo);
            this.backupInfo.setPhase(BackupInfo.BackupPhase.PREPARE_INCREMENTAL);
            LOG.debug("For incremental backup, current table set is " + this.backupManager.getIncrementalBackupTableSet());
            this.newTimestamps = ((IncrementalBackupManager)this.backupManager).getIncrBackupLogFileMap();
        }
        catch (Exception e) {
            this.failBackup(this.conn, this.backupInfo, this.backupManager, e, "Unexpected Exception : ", BackupType.INCREMENTAL, this.conf);
            throw new IOException(e);
        }
        try {
            BackupUtils.copyTableRegionInfo(this.conn, this.backupInfo, this.conf);
            this.setupRegionLocator();
            this.convertWALsToHFiles();
            this.incrementalCopyHFiles(new String[]{this.getBulkOutputDir().toString()}, this.backupInfo.getBackupRootDir());
        }
        catch (Exception e) {
            String msg = "Unexpected exception in incremental-backup: incremental copy " + this.backupId;
            this.failBackup(this.conn, this.backupInfo, this.backupManager, e, msg, BackupType.INCREMENTAL, this.conf);
            throw new IOException(e);
        }
        try {
            Map<TableName, Map<String, Long>> previousTimestampMap = this.backupManager.readLogTimestampMap();
            this.backupInfo.setIncrTimestampMap(previousTimestampMap);
            this.backupManager.writeRegionServerLogTimestamp(this.backupInfo.getTables(), this.newTimestamps);
            Map<TableName, Map<String, Long>> newTableSetTimestampMap = this.backupManager.readLogTimestampMap();
            this.backupInfo.setTableSetTimestampMap(newTableSetTimestampMap);
            Long newStartCode = BackupUtils.getMinValue(BackupUtils.getRSLogTimestampMins(newTableSetTimestampMap));
            this.backupManager.writeBackupStartCode(newStartCode);
            List<BulkLoad> bulkLoads = this.handleBulkLoad(this.backupInfo.getTableNames());
            this.completeBackup(this.conn, this.backupInfo, BackupType.INCREMENTAL, this.conf);
            List bulkLoadedRows = Lists.transform(bulkLoads, BulkLoad::getRowKey);
            this.backupManager.deleteBulkLoadedRows(bulkLoadedRows);
        }
        catch (IOException e) {
            this.failBackup(this.conn, this.backupInfo, this.backupManager, e, "Unexpected Exception : ", BackupType.INCREMENTAL, this.conf);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementalCopyHFiles(String[] files, String backupDest) throws IOException {
        boolean diskBasedSortingOriginalValue = HFileOutputFormat2.diskBasedSortingEnabled((Configuration)this.conf);
        try {
            LOG.debug("Incremental copy HFiles is starting. dest=" + backupDest);
            this.backupInfo.setPhase(BackupInfo.BackupPhase.INCREMENTAL_COPY);
            String[] strArr = new String[files.length + 1];
            System.arraycopy(files, 0, strArr, 0, files.length);
            strArr[strArr.length - 1] = backupDest;
            String jobname = "Incremental_Backup-HFileCopy-" + this.backupInfo.getBackupId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting incremental copy HFiles job name to : " + jobname);
            }
            this.conf.set("mapreduce.job.name", jobname);
            this.conf.setBoolean("hbase.mapreduce.hfileoutputformat.disk.based.sorting.enabled", true);
            BackupCopyJob copyService = BackupRestoreFactory.getBackupCopyJob(this.conf);
            int res = copyService.copy(this.backupInfo, this.backupManager, this.conf, BackupType.INCREMENTAL, strArr);
            if (res != 0) {
                LOG.error("Copy incremental HFile files failed with return code: " + res + ".");
                throw new IOException("Failed copy from " + StringUtils.join((Object[])files, (char)',') + " to " + backupDest);
            }
            LOG.debug("Incremental copy HFiles from " + StringUtils.join((Object[])files, (char)',') + " to " + backupDest + " finished.");
        }
        finally {
            this.deleteBulkLoadDirectory();
            this.conf.setBoolean("hbase.mapreduce.hfileoutputformat.disk.based.sorting.enabled", diskBasedSortingOriginalValue);
        }
    }

    protected void deleteBulkLoadDirectory() throws IOException {
        Path path = this.getBulkOutputDir();
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)this.conf);
        boolean result = fs.delete(path, true);
        if (!result) {
            LOG.warn("Could not delete " + path);
        }
    }

    protected void convertWALsToHFiles() throws IOException {
        List<String> incrBackupFileList = this.backupInfo.getIncrBackupFileList();
        Set<TableName> tableSet = this.backupManager.getIncrementalBackupTableSet();
        incrBackupFileList = this.filterMissingFiles(incrBackupFileList);
        ArrayList<String> tableList = new ArrayList<String>();
        for (TableName table : tableSet) {
            if (this.tableExists(table, this.conn)) {
                tableList.add(table.getNameAsString());
                continue;
            }
            LOG.warn("Table " + table + " does not exists. Skipping in WAL converter");
        }
        this.walToHFiles(incrBackupFileList, tableList);
    }

    protected boolean tableExists(TableName table, Connection conn) throws IOException {
        try (Admin admin = conn.getAdmin();){
            boolean bl = admin.tableExists(table);
            return bl;
        }
    }

    protected void walToHFiles(List<String> dirPaths, List<String> tableList) throws IOException {
        WALPlayer player = new WALPlayer();
        String dirs = StringUtils.join(dirPaths, (char)';');
        String jobname = "Incremental_Backup-" + this.backupId;
        Path bulkOutputPath = this.getBulkOutputDir();
        this.conf.set("wal.bulk.output", bulkOutputPath.toString());
        this.conf.set("wal.input.separator", ";");
        this.conf.setBoolean("hbase.hfileoutputformat.tablename.namespace.inclusive", true);
        this.conf.setBoolean("wal.multi.tables.support", true);
        this.conf.set("mapreduce.job.name", jobname);
        boolean diskBasedSortingEnabledOriginalValue = HFileOutputFormat2.diskBasedSortingEnabled((Configuration)this.conf);
        this.conf.setBoolean("hbase.mapreduce.hfileoutputformat.disk.based.sorting.enabled", true);
        String[] playerArgs = new String[]{dirs, StringUtils.join(tableList, (String)",")};
        try {
            player.setConf(this.conf);
            int result = player.run(playerArgs);
            if (result != 0) {
                throw new IOException("WAL Player failed");
            }
            this.conf.unset("wal.input.separator");
            this.conf.unset("mapreduce.job.name");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new IOException("Can not convert from directory " + dirs + " (check Hadoop, HBase and WALPlayer M/R job logs) ", ee);
        }
        finally {
            this.conf.setBoolean("hbase.mapreduce.hfileoutputformat.disk.based.sorting.enabled", diskBasedSortingEnabledOriginalValue);
            this.conf.unset("wal.input.separator");
            this.conf.unset("mapreduce.job.name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalCopyBulkloadHFiles(FileSystem tgtFs, TableName tn) throws IOException {
        Path bulkOutDir = this.getBulkOutputDirForTable(tn);
        if (tgtFs.exists(bulkOutDir)) {
            this.conf.setInt("num.levels.preserve", 2);
            Path tgtPath = this.getTargetDirForTable(tn);
            try {
                RemoteIterator locatedFiles = tgtFs.listFiles(bulkOutDir, true);
                ArrayList<String> files = new ArrayList<String>();
                while (locatedFiles.hasNext()) {
                    LocatedFileStatus file = (LocatedFileStatus)locatedFiles.next();
                    if (!file.isFile() || !HFile.isHFileFormat((FileSystem)tgtFs, (Path)file.getPath())) continue;
                    files.add(file.getPath().toString());
                }
                this.incrementalCopyHFiles(files.toArray(files.toArray(new String[0])), tgtPath.toString());
            }
            finally {
                this.conf.unset("num.levels.preserve");
            }
        }
    }

    protected Path getBulkOutputDirForTable(TableName table) {
        Path tablePath = this.getBulkOutputDir();
        tablePath = new Path(tablePath, table.getNamespaceAsString());
        tablePath = new Path(tablePath, table.getQualifierAsString());
        return new Path(tablePath, "data");
    }

    protected Path getBulkOutputDir() {
        String backupId = this.backupInfo.getBackupId();
        Path path = new Path(this.backupInfo.getBackupRootDir());
        path = new Path(path, ".tmp");
        path = new Path(path, backupId);
        return path;
    }

    private Path getTargetDirForTable(TableName table) {
        Path path = new Path(this.backupInfo.getBackupRootDir() + "/" + this.backupInfo.getBackupId());
        path = new Path(path, table.getNamespaceAsString());
        path = new Path(path, table.getQualifierAsString());
        return path;
    }

    private void setupRegionLocator() throws IOException {
        Map<TableName, String> fullBackupIds = this.getFullBackupIds();
        try (BackupAdminImpl backupAdmin = new BackupAdminImpl(this.conn);){
            for (TableName tableName : this.backupInfo.getTables()) {
                String fullBackupId = fullBackupIds.get(tableName);
                BackupInfo fullBackupInfo = backupAdmin.getBackupInfo(fullBackupId);
                String snapshotName = fullBackupInfo.getSnapshotName(tableName);
                Path root = HBackupFileSystem.getTableBackupPath(tableName, new Path(fullBackupInfo.getBackupRootDir()), fullBackupId);
                String manifestDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)root).toString();
                SnapshotRegionLocator.setSnapshotManifestDir((Configuration)this.conf, (String)manifestDir, (TableName)tableName);
            }
        }
    }

    private Map<TableName, String> getFullBackupIds() throws IOException {
        List<BackupManifest.BackupImage> images = this.getAncestors(this.backupInfo);
        HashMap<TableName, String> results = new HashMap<TableName, String>();
        for (int i = images.size() - 1; i >= 0; --i) {
            BackupManifest.BackupImage image = images.get(i);
            if (image.getType() != BackupType.FULL) continue;
            for (TableName tn : image.getTableNames()) {
                results.put(tn, image.getBackupId());
            }
        }
        return results;
    }

    private void verifyCfCompatibility(Set<TableName> tables, Map<TableName, String> tablesToFullBackupId) throws IOException, ColumnFamilyMismatchException {
        ColumnFamilyMismatchException.ColumnFamilyMismatchExceptionBuilder exBuilder = ColumnFamilyMismatchException.newBuilder();
        try (Admin admin = this.conn.getAdmin();
             BackupAdminImpl backupAdmin = new BackupAdminImpl(this.conn);){
            for (TableName tn : tables) {
                FileSystem fs;
                String backupId = tablesToFullBackupId.get(tn);
                BackupInfo fullBackupInfo = backupAdmin.getBackupInfo(backupId);
                ColumnFamilyDescriptor[] currentCfs = admin.getDescriptor(tn).getColumnFamilies();
                String snapshotName = fullBackupInfo.getSnapshotName(tn);
                Path root = HBackupFileSystem.getTableBackupPath(tn, new Path(fullBackupInfo.getBackupRootDir()), fullBackupInfo.getBackupId());
                Path manifestDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)root);
                try {
                    fs = FileSystem.get((URI)new URI(fullBackupInfo.getBackupRootDir()), (Configuration)this.conf);
                }
                catch (URISyntaxException e) {
                    throw new IOException("Unable to get fs for backup " + fullBackupInfo.getBackupId(), e);
                }
                SnapshotProtos.SnapshotDescription snapshotDescription = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)manifestDir);
                SnapshotManifest manifest = SnapshotManifest.open((Configuration)this.conf, (FileSystem)fs, (Path)manifestDir, (SnapshotProtos.SnapshotDescription)snapshotDescription);
                if (SnapshotDescriptionUtils.isExpiredSnapshot((long)snapshotDescription.getTtl(), (long)snapshotDescription.getCreationTime(), (long)EnvironmentEdgeManager.currentTime())) {
                    throw new SnapshotTTLExpiredException(ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)snapshotDescription));
                }
                ColumnFamilyDescriptor[] backupCfs = manifest.getTableDescriptor().getColumnFamilies();
                if (IncrementalTableBackupClient.areCfsCompatible(currentCfs, backupCfs)) continue;
                exBuilder.addMismatchedTable(tn, currentCfs, backupCfs);
            }
        }
        ColumnFamilyMismatchException ex = exBuilder.build();
        if (!ex.getMismatchedTables().isEmpty()) {
            throw ex;
        }
    }

    private static boolean areCfsCompatible(ColumnFamilyDescriptor[] currentCfs, ColumnFamilyDescriptor[] backupCfs) {
        if (currentCfs.length != backupCfs.length) {
            return false;
        }
        for (int i = 0; i < backupCfs.length; ++i) {
            String backupCf;
            String currentCf = currentCfs[i].getNameAsString();
            if (currentCf.equals(backupCf = backupCfs[i].getNameAsString())) continue;
            return false;
        }
        return true;
    }
}

