/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class ColumnFamilyMismatchException
extends HBaseIOException {
    private final List<TableName> mismatchedTables;

    private ColumnFamilyMismatchException(String msg, List<TableName> mismatchedTables) {
        super(msg);
        this.mismatchedTables = mismatchedTables;
    }

    public List<TableName> getMismatchedTables() {
        return this.mismatchedTables;
    }

    public static ColumnFamilyMismatchExceptionBuilder newBuilder() {
        return new ColumnFamilyMismatchExceptionBuilder();
    }

    public static final class ColumnFamilyMismatchExceptionBuilder {
        private final List<TableName> mismatchedTables = new ArrayList<TableName>();
        private final StringBuilder msg = new StringBuilder();

        public ColumnFamilyMismatchExceptionBuilder addMismatchedTable(TableName tableName, ColumnFamilyDescriptor[] currentCfs, ColumnFamilyDescriptor[] backupCfs) {
            this.mismatchedTables.add(tableName);
            String currentCfsParsed = StringUtils.join((Object[])currentCfs, (char)',');
            String backupCfsParsed = StringUtils.join((Object[])backupCfs, (char)',');
            this.msg.append("\nMismatch in column family descriptor for table: ").append(tableName).append("\n");
            this.msg.append("Current families: ").append(currentCfsParsed).append("\n");
            this.msg.append("Backup families: ").append(backupCfsParsed);
            return this;
        }

        public ColumnFamilyMismatchException build() {
            return new ColumnFamilyMismatchException(this.msg.toString(), this.mismatchedTables);
        }
    }
}

